// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Scale type. </summary>
    public readonly partial struct SqlVmGroupScaleType : IEquatable<SqlVmGroupScaleType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVmGroupScaleType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVmGroupScaleType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string HAValue = "HA";

        /// <summary> HA. </summary>
        public static SqlVmGroupScaleType HA { get; } = new SqlVmGroupScaleType(HAValue);
        /// <summary> Determines if two <see cref="SqlVmGroupScaleType"/> values are the same. </summary>
        public static bool operator ==(SqlVmGroupScaleType left, SqlVmGroupScaleType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVmGroupScaleType"/> values are not the same. </summary>
        public static bool operator !=(SqlVmGroupScaleType left, SqlVmGroupScaleType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVmGroupScaleType"/>. </summary>
        public static implicit operator SqlVmGroupScaleType(string value) => new SqlVmGroupScaleType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVmGroupScaleType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVmGroupScaleType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
