// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Frequency of full backups. In both cases, full backups begin during the next scheduled time window. </summary>
    public readonly partial struct SqlVmFullBackupFrequency : IEquatable<SqlVmFullBackupFrequency>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVmFullBackupFrequency"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVmFullBackupFrequency(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DailyValue = "Daily";
        private const string WeeklyValue = "Weekly";

        /// <summary> Daily. </summary>
        public static SqlVmFullBackupFrequency Daily { get; } = new SqlVmFullBackupFrequency(DailyValue);
        /// <summary> Weekly. </summary>
        public static SqlVmFullBackupFrequency Weekly { get; } = new SqlVmFullBackupFrequency(WeeklyValue);
        /// <summary> Determines if two <see cref="SqlVmFullBackupFrequency"/> values are the same. </summary>
        public static bool operator ==(SqlVmFullBackupFrequency left, SqlVmFullBackupFrequency right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVmFullBackupFrequency"/> values are not the same. </summary>
        public static bool operator !=(SqlVmFullBackupFrequency left, SqlVmFullBackupFrequency right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVmFullBackupFrequency"/>. </summary>
        public static implicit operator SqlVmFullBackupFrequency(string value) => new SqlVmFullBackupFrequency(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVmFullBackupFrequency other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVmFullBackupFrequency other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
