// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of the group and the OS type. </summary>
    public readonly partial struct SqlVmClusterManagerType : IEquatable<SqlVmClusterManagerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVmClusterManagerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVmClusterManagerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string WindowsServerFailoverClusterValue = "WSFC";

        /// <summary> WSFC. </summary>
        public static SqlVmClusterManagerType WindowsServerFailoverCluster { get; } = new SqlVmClusterManagerType(WindowsServerFailoverClusterValue);
        /// <summary> Determines if two <see cref="SqlVmClusterManagerType"/> values are the same. </summary>
        public static bool operator ==(SqlVmClusterManagerType left, SqlVmClusterManagerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVmClusterManagerType"/> values are not the same. </summary>
        public static bool operator !=(SqlVmClusterManagerType left, SqlVmClusterManagerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVmClusterManagerType"/>. </summary>
        public static implicit operator SqlVmClusterManagerType(string value) => new SqlVmClusterManagerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVmClusterManagerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVmClusterManagerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
