// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Cluster type. </summary>
    public readonly partial struct SqlVmClusterConfiguration : IEquatable<SqlVmClusterConfiguration>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlVmClusterConfiguration"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlVmClusterConfiguration(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DomainfulValue = "Domainful";

        /// <summary> Domainful. </summary>
        public static SqlVmClusterConfiguration Domainful { get; } = new SqlVmClusterConfiguration(DomainfulValue);
        /// <summary> Determines if two <see cref="SqlVmClusterConfiguration"/> values are the same. </summary>
        public static bool operator ==(SqlVmClusterConfiguration left, SqlVmClusterConfiguration right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlVmClusterConfiguration"/> values are not the same. </summary>
        public static bool operator !=(SqlVmClusterConfiguration left, SqlVmClusterConfiguration right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlVmClusterConfiguration"/>. </summary>
        public static implicit operator SqlVmClusterConfiguration(string value) => new SqlVmClusterConfiguration(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlVmClusterConfiguration other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlVmClusterConfiguration other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
