// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Configure assessment for databases in your SQL virtual machine. </summary>
    public partial class SqlVmAssessmentSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVmAssessmentSettings"/>. </summary>
        public SqlVmAssessmentSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlVmAssessmentSettings"/>. </summary>
        /// <param name="isEnabled"> Enable or disable assessment feature on SQL virtual machine. </param>
        /// <param name="runImmediately"> Run assessment immediately on SQL virtual machine. </param>
        /// <param name="schedule"> Schedule for Assessment. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVmAssessmentSettings(bool? isEnabled, bool? runImmediately, SqlVmAssessmentSchedule schedule, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEnabled = isEnabled;
            RunImmediately = runImmediately;
            Schedule = schedule;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Enable or disable assessment feature on SQL virtual machine. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> Run assessment immediately on SQL virtual machine. </summary>
        public bool? RunImmediately { get; set; }
        /// <summary> Schedule for Assessment. </summary>
        public SqlVmAssessmentSchedule Schedule { get; set; }
    }
}
