// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Set disk storage settings for SQL Server. </summary>
    public partial class SqlStorageSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlStorageSettings"/>. </summary>
        public SqlStorageSettings()
        {
            Luns = new ChangeTrackingList<int>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlStorageSettings"/>. </summary>
        /// <param name="luns"> Logical Unit Numbers for the disks. </param>
        /// <param name="defaultFilePath"> SQL Server default file path. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlStorageSettings(IList<int> luns, string defaultFilePath, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Luns = luns;
            DefaultFilePath = defaultFilePath;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Logical Unit Numbers for the disks. </summary>
        public IList<int> Luns { get; }
        /// <summary> SQL Server default file path. </summary>
        public string DefaultFilePath { get; set; }
    }
}
