// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> SQL Server license type. </summary>
    public readonly partial struct SqlServerLicenseType : IEquatable<SqlServerLicenseType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlServerLicenseType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlServerLicenseType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PaygValue = "PAYG";
        private const string AhubValue = "AHUB";
        private const string DRValue = "DR";

        /// <summary> PAYG. </summary>
        public static SqlServerLicenseType Payg { get; } = new SqlServerLicenseType(PaygValue);
        /// <summary> AHUB. </summary>
        public static SqlServerLicenseType Ahub { get; } = new SqlServerLicenseType(AhubValue);
        /// <summary> DR. </summary>
        public static SqlServerLicenseType DR { get; } = new SqlServerLicenseType(DRValue);
        /// <summary> Determines if two <see cref="SqlServerLicenseType"/> values are the same. </summary>
        public static bool operator ==(SqlServerLicenseType left, SqlServerLicenseType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlServerLicenseType"/> values are not the same. </summary>
        public static bool operator !=(SqlServerLicenseType left, SqlServerLicenseType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlServerLicenseType"/>. </summary>
        public static implicit operator SqlServerLicenseType(string value) => new SqlServerLicenseType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlServerLicenseType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlServerLicenseType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
