// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> SQL Server edition type. </summary>
    public readonly partial struct SqlImageSku : IEquatable<SqlImageSku>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SqlImageSku"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SqlImageSku(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DeveloperValue = "Developer";
        private const string ExpressValue = "Express";
        private const string StandardValue = "Standard";
        private const string EnterpriseValue = "Enterprise";
        private const string WebValue = "Web";

        /// <summary> Developer. </summary>
        public static SqlImageSku Developer { get; } = new SqlImageSku(DeveloperValue);
        /// <summary> Express. </summary>
        public static SqlImageSku Express { get; } = new SqlImageSku(ExpressValue);
        /// <summary> Standard. </summary>
        public static SqlImageSku Standard { get; } = new SqlImageSku(StandardValue);
        /// <summary> Enterprise. </summary>
        public static SqlImageSku Enterprise { get; } = new SqlImageSku(EnterpriseValue);
        /// <summary> Web. </summary>
        public static SqlImageSku Web { get; } = new SqlImageSku(WebValue);
        /// <summary> Determines if two <see cref="SqlImageSku"/> values are the same. </summary>
        public static bool operator ==(SqlImageSku left, SqlImageSku right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SqlImageSku"/> values are not the same. </summary>
        public static bool operator !=(SqlImageSku left, SqlImageSku right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SqlImageSku"/>. </summary>
        public static implicit operator SqlImageSku(string value) => new SqlImageSku(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SqlImageSku other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SqlImageSku other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
