// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Replica readable secondary mode in availability group. </summary>
    public readonly partial struct ReadableSecondaryMode : IEquatable<ReadableSecondaryMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ReadableSecondaryMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ReadableSecondaryMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoValue = "NO";
        private const string AllValue = "ALL";
        private const string ReadOnlyValue = "READ_ONLY";

        /// <summary> NO. </summary>
        public static ReadableSecondaryMode No { get; } = new ReadableSecondaryMode(NoValue);
        /// <summary> ALL. </summary>
        public static ReadableSecondaryMode All { get; } = new ReadableSecondaryMode(AllValue);
        /// <summary> READ_ONLY. </summary>
        public static ReadableSecondaryMode ReadOnly { get; } = new ReadableSecondaryMode(ReadOnlyValue);
        /// <summary> Determines if two <see cref="ReadableSecondaryMode"/> values are the same. </summary>
        public static bool operator ==(ReadableSecondaryMode left, ReadableSecondaryMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ReadableSecondaryMode"/> values are not the same. </summary>
        public static bool operator !=(ReadableSecondaryMode left, ReadableSecondaryMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ReadableSecondaryMode"/>. </summary>
        public static implicit operator ReadableSecondaryMode(string value) => new ReadableSecondaryMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ReadableSecondaryMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ReadableSecondaryMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
