// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Multi subnet ip configuration for an availability group listener. </summary>
    public partial class MultiSubnetIPConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MultiSubnetIPConfiguration"/>. </summary>
        /// <param name="privateIPAddress"> Private IP address. </param>
        /// <param name="sqlVmInstance"> SQL virtual machine instance resource id that are enrolled into the availability group listener. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="privateIPAddress"/> or <paramref name="sqlVmInstance"/> is null. </exception>
        public MultiSubnetIPConfiguration(AvailabilityGroupListenerPrivateIPAddress privateIPAddress, string sqlVmInstance)
        {
            Argument.AssertNotNull(privateIPAddress, nameof(privateIPAddress));
            Argument.AssertNotNull(sqlVmInstance, nameof(sqlVmInstance));

            PrivateIPAddress = privateIPAddress;
            SqlVmInstance = sqlVmInstance;
        }

        /// <summary> Initializes a new instance of <see cref="MultiSubnetIPConfiguration"/>. </summary>
        /// <param name="privateIPAddress"> Private IP address. </param>
        /// <param name="sqlVmInstance"> SQL virtual machine instance resource id that are enrolled into the availability group listener. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MultiSubnetIPConfiguration(AvailabilityGroupListenerPrivateIPAddress privateIPAddress, string sqlVmInstance, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PrivateIPAddress = privateIPAddress;
            SqlVmInstance = sqlVmInstance;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MultiSubnetIPConfiguration"/> for deserialization. </summary>
        internal MultiSubnetIPConfiguration()
        {
        }

        /// <summary> Private IP address. </summary>
        public AvailabilityGroupListenerPrivateIPAddress PrivateIPAddress { get; set; }
        /// <summary> SQL virtual machine instance resource id that are enrolled into the availability group listener. </summary>
        public string SqlVmInstance { get; set; }
    }
}
