// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Replica failover mode in availability group. </summary>
    public readonly partial struct AvailabilityGroupReplicaFailoverMode : IEquatable<AvailabilityGroupReplicaFailoverMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AvailabilityGroupReplicaFailoverMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AvailabilityGroupReplicaFailoverMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AutomaticValue = "AUTOMATIC";
        private const string ManualValue = "MANUAL";

        /// <summary> AUTOMATIC. </summary>
        public static AvailabilityGroupReplicaFailoverMode Automatic { get; } = new AvailabilityGroupReplicaFailoverMode(AutomaticValue);
        /// <summary> MANUAL. </summary>
        public static AvailabilityGroupReplicaFailoverMode Manual { get; } = new AvailabilityGroupReplicaFailoverMode(ManualValue);
        /// <summary> Determines if two <see cref="AvailabilityGroupReplicaFailoverMode"/> values are the same. </summary>
        public static bool operator ==(AvailabilityGroupReplicaFailoverMode left, AvailabilityGroupReplicaFailoverMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AvailabilityGroupReplicaFailoverMode"/> values are not the same. </summary>
        public static bool operator !=(AvailabilityGroupReplicaFailoverMode left, AvailabilityGroupReplicaFailoverMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AvailabilityGroupReplicaFailoverMode"/>. </summary>
        public static implicit operator AvailabilityGroupReplicaFailoverMode(string value) => new AvailabilityGroupReplicaFailoverMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AvailabilityGroupReplicaFailoverMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AvailabilityGroupReplicaFailoverMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
