// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SqlVirtualMachine
{
    internal class SqlVmOperationSource : IOperationSource<SqlVmResource>
    {
        private readonly ArmClient _client;

        internal SqlVmOperationSource(ArmClient client)
        {
            _client = client;
        }

        SqlVmResource IOperationSource<SqlVmResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = SqlVmData.DeserializeSqlVmData(document.RootElement);
            return new SqlVmResource(_client, data);
        }

        async ValueTask<SqlVmResource> IOperationSource<SqlVmResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = SqlVmData.DeserializeSqlVmData(document.RootElement);
            return new SqlVmResource(_client, data);
        }
    }
}
