// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.SqlVirtualMachine.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSqlVirtualMachineArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSqlVirtualMachineArmClient"/> class for mocking. </summary>
        protected MockableSqlVirtualMachineArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSqlVirtualMachineArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSqlVirtualMachineArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSqlVirtualMachineArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing an <see cref="AvailabilityGroupListenerResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="AvailabilityGroupListenerResource.CreateResourceIdentifier" /> to create an <see cref="AvailabilityGroupListenerResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="AvailabilityGroupListenerResource"/> object. </returns>
        public virtual AvailabilityGroupListenerResource GetAvailabilityGroupListenerResource(ResourceIdentifier id)
        {
            AvailabilityGroupListenerResource.ValidateResourceId(id);
            return new AvailabilityGroupListenerResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlVmGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlVmGroupResource.CreateResourceIdentifier" /> to create a <see cref="SqlVmGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlVmGroupResource"/> object. </returns>
        public virtual SqlVmGroupResource GetSqlVmGroupResource(ResourceIdentifier id)
        {
            SqlVmGroupResource.ValidateResourceId(id);
            return new SqlVmGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlVmResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlVmResource.CreateResourceIdentifier" /> to create a <see cref="SqlVmResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlVmResource"/> object. </returns>
        public virtual SqlVmResource GetSqlVmResource(ResourceIdentifier id)
        {
            SqlVmResource.ValidateResourceId(id);
            return new SqlVmResource(Client, id);
        }
    }
}
