// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SqlVirtualMachine.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmSqlVirtualMachineModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="SqlVirtualMachine.AvailabilityGroupListenerData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="provisioningState"> Provisioning state to track the async operation status. </param>
        /// <param name="availabilityGroupName"> Name of the availability group. </param>
        /// <param name="loadBalancerConfigurations"> List of load balancer configurations for an availability group listener. </param>
        /// <param name="multiSubnetIPConfigurations"> List of multi subnet IP configurations for an AG listener. </param>
        /// <param name="createDefaultAvailabilityGroupIfNotExist"> Create a default availability group if it does not exist. </param>
        /// <param name="port"> Listener port. </param>
        /// <param name="availabilityGroupReplicas"> Availability Group configuration. </param>
        /// <returns> A new <see cref="SqlVirtualMachine.AvailabilityGroupListenerData"/> instance for mocking. </returns>
        public static AvailabilityGroupListenerData AvailabilityGroupListenerData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string provisioningState = null, string availabilityGroupName = null, IEnumerable<AvailabilityGroupListenerLoadBalancerConfiguration> loadBalancerConfigurations = null, IEnumerable<MultiSubnetIPConfiguration> multiSubnetIPConfigurations = null, bool? createDefaultAvailabilityGroupIfNotExist = null, int? port = null, IEnumerable<AvailabilityGroupReplica> availabilityGroupReplicas = null)
        {
            loadBalancerConfigurations ??= new List<AvailabilityGroupListenerLoadBalancerConfiguration>();
            multiSubnetIPConfigurations ??= new List<MultiSubnetIPConfiguration>();
            availabilityGroupReplicas ??= new List<AvailabilityGroupReplica>();

            return new AvailabilityGroupListenerData(
                id,
                name,
                resourceType,
                systemData,
                provisioningState,
                availabilityGroupName,
                loadBalancerConfigurations?.ToList(),
                multiSubnetIPConfigurations?.ToList(),
                createDefaultAvailabilityGroupIfNotExist,
                port,
                availabilityGroupReplicas != null ? new AvailabilityGroupConfiguration(availabilityGroupReplicas?.ToList(), serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SqlVirtualMachine.SqlVmGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state to track the async operation status. </param>
        /// <param name="sqlImageOffer"> SQL image offer. Examples may include SQL2016-WS2016, SQL2017-WS2016. </param>
        /// <param name="sqlImageSku"> SQL image sku. </param>
        /// <param name="scaleType"> Scale type. </param>
        /// <param name="clusterManagerType"> Type of cluster manager: Windows Server Failover Cluster (WSFC), implied by the scale type of the group and the OS type. </param>
        /// <param name="clusterConfiguration"> Cluster type. </param>
        /// <param name="windowsServerFailoverClusterDomainProfile"> Cluster Active Directory domain profile. </param>
        /// <returns> A new <see cref="SqlVirtualMachine.SqlVmGroupData"/> instance for mocking. </returns>
        public static SqlVmGroupData SqlVmGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string provisioningState = null, string sqlImageOffer = null, SqlVmGroupImageSku? sqlImageSku = null, SqlVmGroupScaleType? scaleType = null, SqlVmClusterManagerType? clusterManagerType = null, SqlVmClusterConfiguration? clusterConfiguration = null, WindowsServerFailoverClusterDomainProfile windowsServerFailoverClusterDomainProfile = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SqlVmGroupData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                sqlImageOffer,
                sqlImageSku,
                scaleType,
                clusterManagerType,
                clusterConfiguration,
                windowsServerFailoverClusterDomainProfile,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="SqlVirtualMachine.SqlVmData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="identity"> Azure Active Directory identity of the server. Current supported identity types: None, SystemAssigned. </param>
        /// <param name="virtualMachineResourceId"> ARM Resource id of underlying virtual machine created from SQL marketplace image. </param>
        /// <param name="provisioningState"> Provisioning state to track the async operation status. </param>
        /// <param name="sqlImageOffer"> SQL image offer. Examples include SQL2016-WS2016, SQL2017-WS2016. </param>
        /// <param name="sqlServerLicenseType"> SQL Server license type. </param>
        /// <param name="sqlManagement"> SQL Server Management type. </param>
        /// <param name="sqlImageSku"> SQL Server edition type. </param>
        /// <param name="sqlVmGroupResourceId"> ARM resource id of the SQL virtual machine group this SQL virtual machine is or will be part of. </param>
        /// <param name="windowsServerFailoverClusterDomainCredentials"> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </param>
        /// <param name="windowsServerFailoverClusterStaticIP"> Domain credentials for setting up Windows Server Failover Cluster for SQL availability group. </param>
        /// <param name="autoPatchingSettings"> Auto patching settings for applying critical security updates to SQL virtual machine. </param>
        /// <param name="autoBackupSettings"> Auto backup settings for SQL Server. </param>
        /// <param name="keyVaultCredentialSettings"> Key vault credential settings. </param>
        /// <param name="serverConfigurationsManagementSettings"> SQL Server configuration management settings. </param>
        /// <param name="storageConfigurationSettings"> Storage Configuration Settings. </param>
        /// <param name="assessmentSettings"> Assessment Settings. </param>
        /// <returns> A new <see cref="SqlVirtualMachine.SqlVmData"/> instance for mocking. </returns>
        public static SqlVmData SqlVmData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ManagedServiceIdentity identity = null, ResourceIdentifier virtualMachineResourceId = null, string provisioningState = null, string sqlImageOffer = null, SqlServerLicenseType? sqlServerLicenseType = null, SqlManagementMode? sqlManagement = null, SqlImageSku? sqlImageSku = null, ResourceIdentifier sqlVmGroupResourceId = null, WindowsServerFailoverClusterDomainCredentials windowsServerFailoverClusterDomainCredentials = null, IPAddress windowsServerFailoverClusterStaticIP = null, SqlVmAutoPatchingSettings autoPatchingSettings = null, SqlVmAutoBackupSettings autoBackupSettings = null, SqlVmKeyVaultCredentialSettings keyVaultCredentialSettings = null, SqlServerConfigurationsManagementSettings serverConfigurationsManagementSettings = null, SqlVmStorageConfigurationSettings storageConfigurationSettings = null, SqlVmAssessmentSettings assessmentSettings = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SqlVmData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                identity,
                virtualMachineResourceId,
                provisioningState,
                sqlImageOffer,
                sqlServerLicenseType,
                sqlManagement,
                sqlImageSku,
                sqlVmGroupResourceId,
                windowsServerFailoverClusterDomainCredentials,
                windowsServerFailoverClusterStaticIP,
                autoPatchingSettings,
                autoBackupSettings,
                keyVaultCredentialSettings,
                serverConfigurationsManagementSettings,
                storageConfigurationSettings,
                assessmentSettings,
                serializedAdditionalRawData: null);
        }
    }
}
