// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.SqlVirtualMachine.Models;

namespace Azure.ResourceManager.SqlVirtualMachine.Samples
{
    public partial class Sample_SqlVmResource
    {
        // Gets all SQL virtual machines in a subscription.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetSqlVms_GetsAllSQLVirtualMachinesInASubscription()
        {
            // Generated from example definition: specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/stable/2022-02-01/examples/ListSubscriptionSqlVirtualMachine.json
            // this example is just showing the usage of "SqlVirtualMachines_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (SqlVmResource item in subscriptionResource.GetSqlVmsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                SqlVmData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Gets a SQL virtual machine.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsASQLVirtualMachine()
        {
            // Generated from example definition: specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/stable/2022-02-01/examples/GetSqlVirtualMachine.json
            // this example is just showing the usage of "SqlVirtualMachines_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVmResource created on azure
            // for more information of creating SqlVmResource, please refer to the document of SqlVmResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlVmName = "testvm";
            ResourceIdentifier sqlVmResourceId = SqlVmResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlVmName);
            SqlVmResource sqlVm = client.GetSqlVmResource(sqlVmResourceId);

            // invoke the operation
            SqlVmResource result = await sqlVm.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVmData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes a SQL virtual machine.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesASQLVirtualMachine()
        {
            // Generated from example definition: specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/stable/2022-02-01/examples/DeleteSqlVirtualMachine.json
            // this example is just showing the usage of "SqlVirtualMachines_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVmResource created on azure
            // for more information of creating SqlVmResource, please refer to the document of SqlVmResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlVmName = "testvm1";
            ResourceIdentifier sqlVmResourceId = SqlVmResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlVmName);
            SqlVmResource sqlVm = client.GetSqlVmResource(sqlVmResourceId);

            // invoke the operation
            await sqlVm.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Updates a SQL virtual machine tags.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesASQLVirtualMachineTags()
        {
            // Generated from example definition: specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/stable/2022-02-01/examples/UpdateSqlVirtualMachine.json
            // this example is just showing the usage of "SqlVirtualMachines_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVmResource created on azure
            // for more information of creating SqlVmResource, please refer to the document of SqlVmResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlVmName = "testvm";
            ResourceIdentifier sqlVmResourceId = SqlVmResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlVmName);
            SqlVmResource sqlVm = client.GetSqlVmResource(sqlVmResourceId);

            // invoke the operation
            SqlVmPatch patch = new SqlVmPatch()
            {
                Tags =
{
["mytag"] = "myval",
},
            };
            ArmOperation<SqlVmResource> lro = await sqlVm.UpdateAsync(WaitUntil.Completed, patch);
            SqlVmResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            SqlVmData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Uninstalls and reinstalls the SQL Iaas Extension.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Redeploy_UninstallsAndReinstallsTheSQLIaasExtension()
        {
            // Generated from example definition: specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/stable/2022-02-01/examples/RedeploySqlVirtualMachine.json
            // this example is just showing the usage of "SqlVirtualMachines_Redeploy" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVmResource created on azure
            // for more information of creating SqlVmResource, please refer to the document of SqlVmResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlVmName = "testvm";
            ResourceIdentifier sqlVmResourceId = SqlVmResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlVmName);
            SqlVmResource sqlVm = client.GetSqlVmResource(sqlVmResourceId);

            // invoke the operation
            await sqlVm.RedeployAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Starts Assessment on SQL virtual machine
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task StartAssessment_StartsAssessmentOnSQLVirtualMachine()
        {
            // Generated from example definition: specification/sqlvirtualmachine/resource-manager/Microsoft.SqlVirtualMachine/stable/2022-02-01/examples/StartAssessmentOnSqlVirtualMachine.json
            // this example is just showing the usage of "SqlVirtualMachines_StartAssessment" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SqlVmResource created on azure
            // for more information of creating SqlVmResource, please refer to the document of SqlVmResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlVmName = "testvm";
            ResourceIdentifier sqlVmResourceId = SqlVmResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlVmName);
            SqlVmResource sqlVm = client.GetSqlVmResource(sqlVmResourceId);

            // invoke the operation
            await sqlVm.StartAssessmentAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
