// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the VirtualCluster data model.
    /// An Azure SQL virtual cluster.
    /// </summary>
    public partial class VirtualClusterData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualClusterData"/>. </summary>
        /// <param name="location"> The location. </param>
        public VirtualClusterData(AzureLocation location) : base(location)
        {
            ChildResources = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="VirtualClusterData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="subnetId"> Subnet resource ID for the virtual cluster. </param>
        /// <param name="version"> Virtual cluster version. </param>
        /// <param name="childResources"> List of resources in this virtual cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualClusterData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ResourceIdentifier subnetId, string version, IReadOnlyList<string> childResources, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            SubnetId = subnetId;
            Version = version;
            ChildResources = childResources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="VirtualClusterData"/> for deserialization. </summary>
        internal VirtualClusterData()
        {
        }

        /// <summary> Subnet resource ID for the virtual cluster. </summary>
        [WirePath("properties.subnetId")]
        public ResourceIdentifier SubnetId { get; }
        /// <summary> Virtual cluster version. </summary>
        [WirePath("properties.version")]
        public string Version { get; set; }
        /// <summary> List of resources in this virtual cluster. </summary>
        [WirePath("properties.childResources")]
        public IReadOnlyList<string> ChildResources { get; }
    }
}
