// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary> A class representing the SqlVulnerabilityAssessmentScanResult data model. </summary>
    public partial class SqlVulnerabilityAssessmentScanResultData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanResultData"/>. </summary>
        public SqlVulnerabilityAssessmentScanResultData()
        {
            QueryResults = new ChangeTrackingList<IList<string>>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanResultData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="ruleId"> SQL Vulnerability Assessment rule Id. </param>
        /// <param name="status"> SQL Vulnerability Assessment rule result status. </param>
        /// <param name="errorMessage"> SQL Vulnerability Assessment error message. </param>
        /// <param name="isTrimmed"> SQL Vulnerability Assessment is the query results trimmed. </param>
        /// <param name="queryResults"> SQL Vulnerability Assessment query results that was run. </param>
        /// <param name="remediation"> SQL Vulnerability Assessment the remediation details. </param>
        /// <param name="baselineAdjustedResult"> SQL Vulnerability Assessment rule result adjusted with baseline. </param>
        /// <param name="ruleMetadata"> SQL Vulnerability Assessment rule metadata. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentScanResultData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string ruleId, SqlVulnerabilityAssessmentRuleStatus? status, string errorMessage, bool? isTrimmed, IReadOnlyList<IList<string>> queryResults, SqlVulnerabilityAssessmentRemediation remediation, SqlVulnerabilityAssessmentBaselineAdjustedResult baselineAdjustedResult, SqlVulnerabilityAssessmentRuleMetadata ruleMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            RuleId = ruleId;
            Status = status;
            ErrorMessage = errorMessage;
            IsTrimmed = isTrimmed;
            QueryResults = queryResults;
            Remediation = remediation;
            BaselineAdjustedResult = baselineAdjustedResult;
            RuleMetadata = ruleMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SQL Vulnerability Assessment rule Id. </summary>
        [WirePath("properties.ruleId")]
        public string RuleId { get; }
        /// <summary> SQL Vulnerability Assessment rule result status. </summary>
        [WirePath("properties.status")]
        public SqlVulnerabilityAssessmentRuleStatus? Status { get; }
        /// <summary> SQL Vulnerability Assessment error message. </summary>
        [WirePath("properties.errorMessage")]
        public string ErrorMessage { get; }
        /// <summary> SQL Vulnerability Assessment is the query results trimmed. </summary>
        [WirePath("properties.isTrimmed")]
        public bool? IsTrimmed { get; }
        /// <summary> SQL Vulnerability Assessment query results that was run. </summary>
        [WirePath("properties.queryResults")]
        public IReadOnlyList<IList<string>> QueryResults { get; }
        /// <summary> SQL Vulnerability Assessment the remediation details. </summary>
        [WirePath("properties.remediation")]
        public SqlVulnerabilityAssessmentRemediation Remediation { get; }
        /// <summary> SQL Vulnerability Assessment rule result adjusted with baseline. </summary>
        [WirePath("properties.baselineAdjustedResult")]
        public SqlVulnerabilityAssessmentBaselineAdjustedResult BaselineAdjustedResult { get; }
        /// <summary> SQL Vulnerability Assessment rule metadata. </summary>
        [WirePath("properties.ruleMetadata")]
        public SqlVulnerabilityAssessmentRuleMetadata RuleMetadata { get; }
    }
}
