// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the SqlVulnerabilityAssessmentScan data model.
    /// A vulnerability assessment scan record.
    /// </summary>
    public partial class SqlVulnerabilityAssessmentScanData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanData"/>. </summary>
        public SqlVulnerabilityAssessmentScanData()
        {
            Errors = new ChangeTrackingList<SqlVulnerabilityAssessmentScanError>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlVulnerabilityAssessmentScanData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="scanId"> The scan ID. </param>
        /// <param name="triggerType"> The scan trigger type. </param>
        /// <param name="state"> The scan status. </param>
        /// <param name="startOn"> The scan start time (UTC). </param>
        /// <param name="endOn"> The scan end time (UTC). </param>
        /// <param name="errors"> The scan errors. </param>
        /// <param name="server"> The server name. </param>
        /// <param name="database"> The database name. </param>
        /// <param name="sqlVersion"> The SQL version. </param>
        /// <param name="highSeverityFailedRulesCount"> The number of failed rules with high severity. </param>
        /// <param name="mediumSeverityFailedRulesCount"> The number of failed rules with medium severity. </param>
        /// <param name="lowSeverityFailedRulesCount"> The number of failed rules with low severity. </param>
        /// <param name="totalPassedRulesCount"> The number of total passed rules. </param>
        /// <param name="totalFailedRulesCount"> The number of total failed rules. </param>
        /// <param name="totalRulesCount"> The number of total rules assessed. </param>
        /// <param name="isBaselineApplied"> Baseline created for this database, and has one or more rules. </param>
        /// <param name="lastScanOn"> The last scan time. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlVulnerabilityAssessmentScanData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string scanId, VulnerabilityAssessmentScanTriggerType? triggerType, VulnerabilityAssessmentScanState? state, DateTimeOffset? startOn, DateTimeOffset? endOn, IReadOnlyList<SqlVulnerabilityAssessmentScanError> errors, string server, string database, string sqlVersion, int? highSeverityFailedRulesCount, int? mediumSeverityFailedRulesCount, int? lowSeverityFailedRulesCount, int? totalPassedRulesCount, int? totalFailedRulesCount, int? totalRulesCount, bool? isBaselineApplied, DateTimeOffset? lastScanOn, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ScanId = scanId;
            TriggerType = triggerType;
            State = state;
            StartOn = startOn;
            EndOn = endOn;
            Errors = errors;
            Server = server;
            Database = database;
            SqlVersion = sqlVersion;
            HighSeverityFailedRulesCount = highSeverityFailedRulesCount;
            MediumSeverityFailedRulesCount = mediumSeverityFailedRulesCount;
            LowSeverityFailedRulesCount = lowSeverityFailedRulesCount;
            TotalPassedRulesCount = totalPassedRulesCount;
            TotalFailedRulesCount = totalFailedRulesCount;
            TotalRulesCount = totalRulesCount;
            IsBaselineApplied = isBaselineApplied;
            LastScanOn = lastScanOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The scan ID. </summary>
        [WirePath("properties.scanId")]
        public string ScanId { get; }
        /// <summary> The scan trigger type. </summary>
        [WirePath("properties.triggerType")]
        public VulnerabilityAssessmentScanTriggerType? TriggerType { get; }
        /// <summary> The scan status. </summary>
        [WirePath("properties.state")]
        public VulnerabilityAssessmentScanState? State { get; }
        /// <summary> The scan start time (UTC). </summary>
        [WirePath("properties.startTime")]
        public DateTimeOffset? StartOn { get; }
        /// <summary> The scan end time (UTC). </summary>
        [WirePath("properties.endTime")]
        public DateTimeOffset? EndOn { get; }
        /// <summary> The scan errors. </summary>
        [WirePath("properties.errors")]
        public IReadOnlyList<SqlVulnerabilityAssessmentScanError> Errors { get; }
        /// <summary> The server name. </summary>
        [WirePath("properties.server")]
        public string Server { get; }
        /// <summary> The database name. </summary>
        [WirePath("properties.database")]
        public string Database { get; }
        /// <summary> The SQL version. </summary>
        [WirePath("properties.sqlVersion")]
        public string SqlVersion { get; }
        /// <summary> The number of failed rules with high severity. </summary>
        [WirePath("properties.highSeverityFailedRulesCount")]
        public int? HighSeverityFailedRulesCount { get; }
        /// <summary> The number of failed rules with medium severity. </summary>
        [WirePath("properties.mediumSeverityFailedRulesCount")]
        public int? MediumSeverityFailedRulesCount { get; }
        /// <summary> The number of failed rules with low severity. </summary>
        [WirePath("properties.lowSeverityFailedRulesCount")]
        public int? LowSeverityFailedRulesCount { get; }
        /// <summary> The number of total passed rules. </summary>
        [WirePath("properties.totalPassedRulesCount")]
        public int? TotalPassedRulesCount { get; }
        /// <summary> The number of total failed rules. </summary>
        [WirePath("properties.totalFailedRulesCount")]
        public int? TotalFailedRulesCount { get; }
        /// <summary> The number of total rules assessed. </summary>
        [WirePath("properties.totalRulesCount")]
        public int? TotalRulesCount { get; }
        /// <summary> Baseline created for this database, and has one or more rules. </summary>
        [WirePath("properties.isBaselineApplied")]
        public bool? IsBaselineApplied { get; }
        /// <summary> The last scan time. </summary>
        [WirePath("properties.lastScanTime")]
        public DateTimeOffset? LastScanOn { get; }
    }
}
