// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    public partial class SqlVulnerabilityAssessmentScanData : IUtf8JsonSerializable, IJsonModel<SqlVulnerabilityAssessmentScanData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlVulnerabilityAssessmentScanData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlVulnerabilityAssessmentScanData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(ScanId))
            {
                writer.WritePropertyName("scanId"u8);
                writer.WriteStringValue(ScanId);
            }
            if (options.Format != "W" && Optional.IsDefined(TriggerType))
            {
                writer.WritePropertyName("triggerType"u8);
                writer.WriteStringValue(TriggerType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteStringValue(State.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(StartOn))
            {
                writer.WritePropertyName("startTime"u8);
                writer.WriteStringValue(StartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(EndOn))
            {
                writer.WritePropertyName("endTime"u8);
                writer.WriteStringValue(EndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Errors))
            {
                writer.WritePropertyName("errors"u8);
                writer.WriteStartArray();
                foreach (var item in Errors)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(Server))
            {
                writer.WritePropertyName("server"u8);
                writer.WriteStringValue(Server);
            }
            if (options.Format != "W" && Optional.IsDefined(Database))
            {
                writer.WritePropertyName("database"u8);
                writer.WriteStringValue(Database);
            }
            if (options.Format != "W" && Optional.IsDefined(SqlVersion))
            {
                writer.WritePropertyName("sqlVersion"u8);
                writer.WriteStringValue(SqlVersion);
            }
            if (options.Format != "W" && Optional.IsDefined(HighSeverityFailedRulesCount))
            {
                writer.WritePropertyName("highSeverityFailedRulesCount"u8);
                writer.WriteNumberValue(HighSeverityFailedRulesCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(MediumSeverityFailedRulesCount))
            {
                writer.WritePropertyName("mediumSeverityFailedRulesCount"u8);
                writer.WriteNumberValue(MediumSeverityFailedRulesCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LowSeverityFailedRulesCount))
            {
                writer.WritePropertyName("lowSeverityFailedRulesCount"u8);
                writer.WriteNumberValue(LowSeverityFailedRulesCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalPassedRulesCount))
            {
                writer.WritePropertyName("totalPassedRulesCount"u8);
                writer.WriteNumberValue(TotalPassedRulesCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalFailedRulesCount))
            {
                writer.WritePropertyName("totalFailedRulesCount"u8);
                writer.WriteNumberValue(TotalFailedRulesCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(TotalRulesCount))
            {
                writer.WritePropertyName("totalRulesCount"u8);
                writer.WriteNumberValue(TotalRulesCount.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsBaselineApplied))
            {
                writer.WritePropertyName("isBaselineApplied"u8);
                writer.WriteBooleanValue(IsBaselineApplied.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(LastScanOn))
            {
                writer.WritePropertyName("lastScanTime"u8);
                writer.WriteStringValue(LastScanOn.Value, "O");
            }
            writer.WriteEndObject();
        }

        SqlVulnerabilityAssessmentScanData IJsonModel<SqlVulnerabilityAssessmentScanData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlVulnerabilityAssessmentScanData(document.RootElement, options);
        }

        internal static SqlVulnerabilityAssessmentScanData DeserializeSqlVulnerabilityAssessmentScanData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string scanId = default;
            VulnerabilityAssessmentScanTriggerType? triggerType = default;
            VulnerabilityAssessmentScanState? state = default;
            DateTimeOffset? startTime = default;
            DateTimeOffset? endTime = default;
            IReadOnlyList<SqlVulnerabilityAssessmentScanError> errors = default;
            string server = default;
            string database = default;
            string sqlVersion = default;
            int? highSeverityFailedRulesCount = default;
            int? mediumSeverityFailedRulesCount = default;
            int? lowSeverityFailedRulesCount = default;
            int? totalPassedRulesCount = default;
            int? totalFailedRulesCount = default;
            int? totalRulesCount = default;
            bool? isBaselineApplied = default;
            DateTimeOffset? lastScanTime = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("scanId"u8))
                        {
                            scanId = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("triggerType"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            triggerType = new VulnerabilityAssessmentScanTriggerType(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = new VulnerabilityAssessmentScanState(property0.Value.GetString());
                            continue;
                        }
                        if (property0.NameEquals("startTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            startTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("endTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            endTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("errors"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<SqlVulnerabilityAssessmentScanError> array = new List<SqlVulnerabilityAssessmentScanError>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(SqlVulnerabilityAssessmentScanError.DeserializeSqlVulnerabilityAssessmentScanError(item, options));
                            }
                            errors = array;
                            continue;
                        }
                        if (property0.NameEquals("server"u8))
                        {
                            server = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("database"u8))
                        {
                            database = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("sqlVersion"u8))
                        {
                            sqlVersion = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("highSeverityFailedRulesCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            highSeverityFailedRulesCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("mediumSeverityFailedRulesCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            mediumSeverityFailedRulesCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("lowSeverityFailedRulesCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lowSeverityFailedRulesCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("totalPassedRulesCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalPassedRulesCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("totalFailedRulesCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalFailedRulesCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("totalRulesCount"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            totalRulesCount = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("isBaselineApplied"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isBaselineApplied = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("lastScanTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastScanTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlVulnerabilityAssessmentScanData(
                id,
                name,
                type,
                systemData,
                scanId,
                triggerType,
                state,
                startTime,
                endTime,
                errors ?? new ChangeTrackingList<SqlVulnerabilityAssessmentScanError>(),
                server,
                database,
                sqlVersion,
                highSeverityFailedRulesCount,
                mediumSeverityFailedRulesCount,
                lowSeverityFailedRulesCount,
                totalPassedRulesCount,
                totalFailedRulesCount,
                totalRulesCount,
                isBaselineApplied,
                lastScanTime,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ScanId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    scanId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ScanId))
                {
                    builder.Append("    scanId: ");
                    if (ScanId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ScanId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ScanId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TriggerType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    triggerType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TriggerType))
                {
                    builder.Append("    triggerType: ");
                    builder.AppendLine($"'{TriggerType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("    state: ");
                    builder.AppendLine($"'{State.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    startTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StartOn))
                {
                    builder.Append("    startTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(StartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EndOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    endTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EndOn))
                {
                    builder.Append("    endTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(EndOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Errors), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    errors: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Errors))
                {
                    if (Errors.Any())
                    {
                        builder.Append("    errors: ");
                        builder.AppendLine("[");
                        foreach (var item in Errors)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    errors: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Server), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    server: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Server))
                {
                    builder.Append("    server: ");
                    if (Server.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Server}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Server}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Database), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    database: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Database))
                {
                    builder.Append("    database: ");
                    if (Database.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Database}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Database}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SqlVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    sqlVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SqlVersion))
                {
                    builder.Append("    sqlVersion: ");
                    if (SqlVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{SqlVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{SqlVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(HighSeverityFailedRulesCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    highSeverityFailedRulesCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(HighSeverityFailedRulesCount))
                {
                    builder.Append("    highSeverityFailedRulesCount: ");
                    builder.AppendLine($"{HighSeverityFailedRulesCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(MediumSeverityFailedRulesCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    mediumSeverityFailedRulesCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(MediumSeverityFailedRulesCount))
                {
                    builder.Append("    mediumSeverityFailedRulesCount: ");
                    builder.AppendLine($"{MediumSeverityFailedRulesCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LowSeverityFailedRulesCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lowSeverityFailedRulesCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LowSeverityFailedRulesCount))
                {
                    builder.Append("    lowSeverityFailedRulesCount: ");
                    builder.AppendLine($"{LowSeverityFailedRulesCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalPassedRulesCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    totalPassedRulesCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalPassedRulesCount))
                {
                    builder.Append("    totalPassedRulesCount: ");
                    builder.AppendLine($"{TotalPassedRulesCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalFailedRulesCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    totalFailedRulesCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalFailedRulesCount))
                {
                    builder.Append("    totalFailedRulesCount: ");
                    builder.AppendLine($"{TotalFailedRulesCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TotalRulesCount), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    totalRulesCount: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TotalRulesCount))
                {
                    builder.Append("    totalRulesCount: ");
                    builder.AppendLine($"{TotalRulesCount.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsBaselineApplied), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isBaselineApplied: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsBaselineApplied))
                {
                    builder.Append("    isBaselineApplied: ");
                    var boolValue = IsBaselineApplied.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastScanOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastScanTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastScanOn))
                {
                    builder.Append("    lastScanTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastScanOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SqlVulnerabilityAssessmentScanData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanData)} does not support writing '{options.Format}' format.");
            }
        }

        SqlVulnerabilityAssessmentScanData IPersistableModel<SqlVulnerabilityAssessmentScanData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlVulnerabilityAssessmentScanData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlVulnerabilityAssessmentScanData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlVulnerabilityAssessmentScanData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlVulnerabilityAssessmentScanData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
