// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the SqlServerTrustGroup data model.
    /// A server trust group.
    /// </summary>
    public partial class SqlServerTrustGroupData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlServerTrustGroupData"/>. </summary>
        public SqlServerTrustGroupData()
        {
            GroupMembers = new ChangeTrackingList<ServerTrustGroupServerInfo>();
            TrustScopes = new ChangeTrackingList<ServerTrustGroupPropertiesTrustScopesItem>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlServerTrustGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupMembers"> Group members information for the server trust group. </param>
        /// <param name="trustScopes"> Trust scope of the server trust group. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlServerTrustGroupData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IList<ServerTrustGroupServerInfo> groupMembers, IList<ServerTrustGroupPropertiesTrustScopesItem> trustScopes, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            GroupMembers = groupMembers;
            TrustScopes = trustScopes;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Group members information for the server trust group. </summary>
        [WirePath("properties.groupMembers")]
        public IList<ServerTrustGroupServerInfo> GroupMembers { get; }
        /// <summary> Trust scope of the server trust group. </summary>
        [WirePath("properties.trustScopes")]
        public IList<ServerTrustGroupPropertiesTrustScopesItem> TrustScopes { get; }
    }
}
