// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> and their operations.
    /// Each <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> in the collection will belong to the same instance of <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/>.
    /// To get a <see cref="SqlServerSqlVulnerabilityAssessmentScanResultCollection"/> instance call the GetSqlServerSqlVulnerabilityAssessmentScanResults method from an instance of <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/>.
    /// </summary>
    public partial class SqlServerSqlVulnerabilityAssessmentScanResultCollection : ArmCollection, IEnumerable<SqlServerSqlVulnerabilityAssessmentScanResultResource>, IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentScanResultResource>
    {
        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentScanResultRestOperations _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanResultCollection"/> class for mocking. </summary>
        protected SqlServerSqlVulnerabilityAssessmentScanResultCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanResultCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentScanResultCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlServerSqlVulnerabilityAssessmentScanResultResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlServerSqlVulnerabilityAssessmentScanResultResource.ResourceType, out string sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultApiVersion);
            _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient = new SqlVulnerabilityAssessmentScanResultRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlServerSqlVulnerabilityAssessmentScanResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlServerSqlVulnerabilityAssessmentScanResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentScanResultResource>> GetAsync(string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResultCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanResultId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual Response<SqlServerSqlVulnerabilityAssessmentScanResultResource> Get(string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResultCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanResultId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_ListByScan</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlServerSqlVulnerabilityAssessmentScanResultResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.CreateListByScanRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.CreateListByScanNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, SqlVulnerabilityAssessmentScanResultData.DeserializeSqlVulnerabilityAssessmentScanResultData(e)), _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentScanResultCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_ListByScan</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlServerSqlVulnerabilityAssessmentScanResultResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.CreateListByScanRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.CreateListByScanNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, SqlVulnerabilityAssessmentScanResultData.DeserializeSqlVulnerabilityAssessmentScanResultData(e)), _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentScanResultCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResultCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanResultId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResultCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanResultId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlServerSqlVulnerabilityAssessmentScanResultResource>> GetIfExistsAsync(string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResultCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanResultId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentScanResultResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        public virtual NullableResponse<SqlServerSqlVulnerabilityAssessmentScanResultResource> GetIfExists(string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResultCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanResultSqlVulnerabilityAssessmentScanResultRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanResultId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentScanResultResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResultResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlServerSqlVulnerabilityAssessmentScanResultResource> IEnumerable<SqlServerSqlVulnerabilityAssessmentScanResultResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlServerSqlVulnerabilityAssessmentScanResultResource> IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentScanResultResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
