// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A Class representing a SqlServerSqlVulnerabilityAssessmentScan along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlServerSqlVulnerabilityAssessmentScanResource method.
    /// Otherwise you can get one from its parent resource <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> using the GetSqlServerSqlVulnerabilityAssessmentScan method.
    /// </summary>
    public partial class SqlServerSqlVulnerabilityAssessmentScanResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="serverName"> The serverName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        /// <param name="scanId"> The scanId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentScansRestOperations _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient;
        private readonly SqlVulnerabilityAssessmentScanData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Sql/servers/sqlVulnerabilityAssessments/scans";

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> class for mocking. </summary>
        protected SqlServerSqlVulnerabilityAssessmentScanResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentScanResource(ArmClient client, SqlVulnerabilityAssessmentScanData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentScanResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansApiVersion);
            _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient = new SqlVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SqlVulnerabilityAssessmentScanData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of SqlServerSqlVulnerabilityAssessmentScanResultResources in the SqlServerSqlVulnerabilityAssessmentScan. </summary>
        /// <returns> An object representing collection of SqlServerSqlVulnerabilityAssessmentScanResultResources and their operations over a SqlServerSqlVulnerabilityAssessmentScanResultResource. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentScanResultCollection GetSqlServerSqlVulnerabilityAssessmentScanResults()
        {
            return GetCachedClient(client => new SqlServerSqlVulnerabilityAssessmentScanResultCollection(client, Id));
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentScanResultResource>> GetSqlServerSqlVulnerabilityAssessmentScanResultAsync(string scanResultId, CancellationToken cancellationToken = default)
        {
            return await GetSqlServerSqlVulnerabilityAssessmentScanResults().GetAsync(scanResultId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/scanResults/{scanResultId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScanResult_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResultResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scanResultId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SqlServerSqlVulnerabilityAssessmentScanResultResource> GetSqlServerSqlVulnerabilityAssessmentScanResult(string scanResultId, CancellationToken cancellationToken = default)
        {
            return GetSqlServerSqlVulnerabilityAssessmentScanResults().Get(scanResultId, cancellationToken);
        }

        /// <summary>
        /// Get a system database vulnerability assessment scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentScanResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a system database vulnerability assessment scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlServerSqlVulnerabilityAssessmentScanResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanResource.Get");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
