// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> and their operations.
    /// Each <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> in the collection will belong to the same instance of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SqlServerSqlVulnerabilityAssessmentScanCollection"/> instance call the GetSqlServerSqlVulnerabilityAssessmentScans method from an instance of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SqlServerSqlVulnerabilityAssessmentScanCollection : ArmCollection, IEnumerable<SqlServerSqlVulnerabilityAssessmentScanResource>, IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentScanResource>
    {
        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentScansRestOperations _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanCollection"/> class for mocking. </summary>
        protected SqlServerSqlVulnerabilityAssessmentScanCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentScanCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentScanCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlServerSqlVulnerabilityAssessmentScanResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlServerSqlVulnerabilityAssessmentScanResource.ResourceType, out string sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansApiVersion);
            _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient = new SqlVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlServerSqlVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlServerSqlVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a system database vulnerability assessment scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentScanResource>> GetAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, scanId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a system database vulnerability assessment scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<SqlServerSqlVulnerabilityAssessmentScanResource> Get(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, scanId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_ListBySqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlServerSqlVulnerabilityAssessmentScanResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentScanResource(Client, SqlVulnerabilityAssessmentScanData.DeserializeSqlVulnerabilityAssessmentScanData(e)), _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_ListBySqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlServerSqlVulnerabilityAssessmentScanResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentScanResource(Client, SqlVulnerabilityAssessmentScanData.DeserializeSqlVulnerabilityAssessmentScanData(e)), _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlServerSqlVulnerabilityAssessmentScanResource>> GetIfExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual NullableResponse<SqlServerSqlVulnerabilityAssessmentScanResource> GetIfExists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentScanSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlServerSqlVulnerabilityAssessmentScanResource> IEnumerable<SqlServerSqlVulnerabilityAssessmentScanResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlServerSqlVulnerabilityAssessmentScanResource> IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentScanResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
