// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A Class representing a SqlServerSqlVulnerabilityAssessment along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlServerSqlVulnerabilityAssessmentResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlServerSqlVulnerabilityAssessmentResource method.
    /// Otherwise you can get one from its parent resource <see cref="SqlServerResource"/> using the GetSqlServerSqlVulnerabilityAssessment method.
    /// </summary>
    public partial class SqlServerSqlVulnerabilityAssessmentResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="serverName"> The serverName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentsSettingsRestOperations _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient;
        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentsRestOperations _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsRestClient;
        private readonly ClientDiagnostics _sqlVulnerabilityAssessmentExecuteScanClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentExecuteScanRestOperations _sqlVulnerabilityAssessmentExecuteScanRestClient;
        private readonly SqlVulnerabilityAssessmentData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Sql/servers/sqlVulnerabilityAssessments";

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> class for mocking. </summary>
        protected SqlServerSqlVulnerabilityAssessmentResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentResource(ArmClient client, SqlVulnerabilityAssessmentData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsApiVersion);
            _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient = new SqlVulnerabilityAssessmentsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsApiVersion);
            _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsApiVersion);
            _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsRestClient = new SqlVulnerabilityAssessmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsApiVersion);
            _sqlVulnerabilityAssessmentExecuteScanClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _sqlVulnerabilityAssessmentExecuteScanRestClient = new SqlVulnerabilityAssessmentExecuteScanRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SqlVulnerabilityAssessmentData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of SqlServerSqlVulnerabilityAssessmentBaselineResources in the SqlServerSqlVulnerabilityAssessment. </summary>
        /// <returns> An object representing collection of SqlServerSqlVulnerabilityAssessmentBaselineResources and their operations over a SqlServerSqlVulnerabilityAssessmentBaselineResource. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentBaselineCollection GetSqlServerSqlVulnerabilityAssessmentBaselines()
        {
            return GetCachedClient(client => new SqlServerSqlVulnerabilityAssessmentBaselineCollection(client, Id));
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentBaselineResource>> GetSqlServerSqlVulnerabilityAssessmentBaselineAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            return await GetSqlServerSqlVulnerabilityAssessmentBaselines().GetAsync(baselineName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual Response<SqlServerSqlVulnerabilityAssessmentBaselineResource> GetSqlServerSqlVulnerabilityAssessmentBaseline(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            return GetSqlServerSqlVulnerabilityAssessmentBaselines().Get(baselineName, cancellationToken);
        }

        /// <summary> Gets a collection of SqlServerSqlVulnerabilityAssessmentScanResources in the SqlServerSqlVulnerabilityAssessment. </summary>
        /// <returns> An object representing collection of SqlServerSqlVulnerabilityAssessmentScanResources and their operations over a SqlServerSqlVulnerabilityAssessmentScanResource. </returns>
        public virtual SqlServerSqlVulnerabilityAssessmentScanCollection GetSqlServerSqlVulnerabilityAssessmentScans()
        {
            return GetCachedClient(client => new SqlServerSqlVulnerabilityAssessmentScanCollection(client, Id));
        }

        /// <summary>
        /// Get a system database vulnerability assessment scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentScanResource>> GetSqlServerSqlVulnerabilityAssessmentScanAsync(string scanId, CancellationToken cancellationToken = default)
        {
            return await GetSqlServerSqlVulnerabilityAssessmentScans().GetAsync(scanId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a system database vulnerability assessment scan record.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The <see cref="string"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SqlServerSqlVulnerabilityAssessmentScanResource> GetSqlServerSqlVulnerabilityAssessmentScan(string scanId, CancellationToken cancellationToken = default)
        {
            return GetSqlServerSqlVulnerabilityAssessmentScans().Get(scanId, cancellationToken);
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlServerSqlVulnerabilityAssessmentResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.Get");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes SQL Vulnerability Assessment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessments_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.Delete");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var uri = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes SQL Vulnerability Assessment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessments_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.Delete");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                var uri = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The requested resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlServerSqlVulnerabilityAssessmentResource>> UpdateAsync(WaitUntil waitUntil, SqlVulnerabilityAssessmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.Update");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, data, cancellationToken).ConfigureAwait(false);
                var uri = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlServerSqlVulnerabilityAssessmentResource>(Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The requested resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SqlServerSqlVulnerabilityAssessmentResource> Update(WaitUntil waitUntil, SqlVulnerabilityAssessmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.Update");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, data, cancellationToken);
                var uri = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlServerSqlVulnerabilityAssessmentResource>(Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Executes a Vulnerability Assessment database scan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/initiateScan</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentExecuteScan_Execute</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> ExecuteScanAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentExecuteScanClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.ExecuteScan");
            scope.Start();
            try
            {
                var response = await _sqlVulnerabilityAssessmentExecuteScanRestClient.ExecuteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new SqlArmOperation(_sqlVulnerabilityAssessmentExecuteScanClientDiagnostics, Pipeline, _sqlVulnerabilityAssessmentExecuteScanRestClient.CreateExecuteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Executes a Vulnerability Assessment database scan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/initiateScan</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentExecuteScan_Execute</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation ExecuteScan(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlVulnerabilityAssessmentExecuteScanClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentResource.ExecuteScan");
            scope.Start();
            try
            {
                var response = _sqlVulnerabilityAssessmentExecuteScanRestClient.Execute(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, cancellationToken);
                var operation = new SqlArmOperation(_sqlVulnerabilityAssessmentExecuteScanClientDiagnostics, Pipeline, _sqlVulnerabilityAssessmentExecuteScanRestClient.CreateExecuteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
