// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> and their operations.
    /// Each <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> in the collection will belong to the same instance of <see cref="SqlServerResource"/>.
    /// To get a <see cref="SqlServerSqlVulnerabilityAssessmentCollection"/> instance call the GetSqlServerSqlVulnerabilityAssessments method from an instance of <see cref="SqlServerResource"/>.
    /// </summary>
    public partial class SqlServerSqlVulnerabilityAssessmentCollection : ArmCollection, IEnumerable<SqlServerSqlVulnerabilityAssessmentResource>, IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentResource>
    {
        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentsSettingsRestOperations _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentCollection"/> class for mocking. </summary>
        protected SqlServerSqlVulnerabilityAssessmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlServerSqlVulnerabilityAssessmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlServerSqlVulnerabilityAssessmentResource.ResourceType, out string sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsApiVersion);
            _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient = new SqlVulnerabilityAssessmentsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlServerResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlServerResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="data"> The requested resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlServerSqlVulnerabilityAssessmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, data, cancellationToken).ConfigureAwait(false);
                var uri = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlServerSqlVulnerabilityAssessmentResource>(Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="data"> The requested resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SqlServerSqlVulnerabilityAssessmentResource> CreateOrUpdate(WaitUntil waitUntil, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, data, cancellationToken);
                var uri = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlServerSqlVulnerabilityAssessmentResource>(Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentResource>> GetAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlServerSqlVulnerabilityAssessmentResource> Get(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists SQL Vulnerability Assessment policies associated with a server.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_ListByServer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlServerSqlVulnerabilityAssessmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByServerRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByServerNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentResource(Client, SqlVulnerabilityAssessmentData.DeserializeSqlVulnerabilityAssessmentData(e)), _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists SQL Vulnerability Assessment policies associated with a server.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_ListByServer</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlServerSqlVulnerabilityAssessmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByServerRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByServerNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentResource(Client, SqlVulnerabilityAssessmentData.DeserializeSqlVulnerabilityAssessmentData(e)), _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SqlServerSqlVulnerabilityAssessmentResource>> GetIfExistsAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SqlServerSqlVulnerabilityAssessmentResource> GetIfExists(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlServerSqlVulnerabilityAssessmentResource> IEnumerable<SqlServerSqlVulnerabilityAssessmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlServerSqlVulnerabilityAssessmentResource> IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
