// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> and their operations.
    /// Each <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> in the collection will belong to the same instance of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SqlServerSqlVulnerabilityAssessmentBaselineCollection"/> instance call the GetSqlServerSqlVulnerabilityAssessmentBaselines method from an instance of <see cref="SqlServerSqlVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SqlServerSqlVulnerabilityAssessmentBaselineCollection : ArmCollection, IEnumerable<SqlServerSqlVulnerabilityAssessmentBaselineResource>, IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentBaselineResource>
    {
        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentBaselinesRestOperations _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesRestClient;
        private readonly ClientDiagnostics _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics;
        private readonly SqlVulnerabilityAssessmentBaselineRestOperations _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentBaselineCollection"/> class for mocking. </summary>
        protected SqlServerSqlVulnerabilityAssessmentBaselineCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlServerSqlVulnerabilityAssessmentBaselineCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlServerSqlVulnerabilityAssessmentBaselineCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlServerSqlVulnerabilityAssessmentBaselineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlServerSqlVulnerabilityAssessmentBaselineResource.ResourceType, out string sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesApiVersion);
            _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesRestClient = new SqlVulnerabilityAssessmentBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesApiVersion);
            _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlServerSqlVulnerabilityAssessmentBaselineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlServerSqlVulnerabilityAssessmentBaselineResource.ResourceType, out string sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineApiVersion);
            _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient = new SqlVulnerabilityAssessmentBaselineRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlServerSqlVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlServerSqlVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Add a database's vulnerability assessment rule baseline list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineResource>> CreateOrUpdateAsync(WaitUntil waitUntil, SqlVulnerabilityAssessmentBaselineName baselineName, SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, content, cancellationToken).ConfigureAwait(false);
                var uri = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineResource>(Response.FromValue(new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a database's vulnerability assessment rule baseline list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineResource> CreateOrUpdate(WaitUntil waitUntil, SqlVulnerabilityAssessmentBaselineName baselineName, SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, content, cancellationToken);
                var uri = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlServerSqlVulnerabilityAssessmentBaselineResource>(Response.FromValue(new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlServerSqlVulnerabilityAssessmentBaselineResource>> GetAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlServerSqlVulnerabilityAssessmentBaselineResource> Get(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_ListBySqlVulnerabilityAssessment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlServerSqlVulnerabilityAssessmentBaselineResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.CreateListBySqlVulnerabilityAssessmentRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.CreateListBySqlVulnerabilityAssessmentNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, SqlVulnerabilityAssessmentBaselineData.DeserializeSqlVulnerabilityAssessmentBaselineData(e)), _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentBaselineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_ListBySqlVulnerabilityAssessment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlServerSqlVulnerabilityAssessmentBaselineResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.CreateListBySqlVulnerabilityAssessmentRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.CreateListBySqlVulnerabilityAssessmentNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, SqlVulnerabilityAssessmentBaselineData.DeserializeSqlVulnerabilityAssessmentBaselineData(e)), _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics, Pipeline, "SqlServerSqlVulnerabilityAssessmentBaselineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SqlServerSqlVulnerabilityAssessmentBaselineResource>> GetIfExistsAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>SqlVulnerabilityAssessmentBaseline_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlServerSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SqlServerSqlVulnerabilityAssessmentBaselineResource> GetIfExists(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineClientDiagnostics.CreateScope("SqlServerSqlVulnerabilityAssessmentBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlServerSqlVulnerabilityAssessmentBaselineSqlVulnerabilityAssessmentBaselineRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlServerSqlVulnerabilityAssessmentBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SqlServerSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlServerSqlVulnerabilityAssessmentBaselineResource> IEnumerable<SqlServerSqlVulnerabilityAssessmentBaselineResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlServerSqlVulnerabilityAssessmentBaselineResource> IAsyncEnumerable<SqlServerSqlVulnerabilityAssessmentBaselineResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
