// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the SqlServerJob data model.
    /// A job.
    /// </summary>
    public partial class SqlServerJobData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlServerJobData"/>. </summary>
        public SqlServerJobData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SqlServerJobData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="description"> User-defined description of the job. </param>
        /// <param name="version"> The job version number. </param>
        /// <param name="schedule"> Schedule properties of the job. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlServerJobData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string description, int? version, SqlServerJobSchedule schedule, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Description = description;
            Version = version;
            Schedule = schedule;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> User-defined description of the job. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The job version number. </summary>
        [WirePath("properties.version")]
        public int? Version { get; }
        /// <summary> Schedule properties of the job. </summary>
        [WirePath("properties.schedule")]
        public SqlServerJobSchedule Schedule { get; set; }
    }
}
