// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A Class representing a SqlDatabaseVulnerabilityAssessmentScan along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlDatabaseVulnerabilityAssessmentScanResource method.
    /// Otherwise you can get one from its parent resource <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> using the GetSqlDatabaseVulnerabilityAssessmentScan method.
    /// </summary>
    public partial class SqlDatabaseVulnerabilityAssessmentScanResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="serverName"> The serverName. </param>
        /// <param name="databaseName"> The databaseName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        /// <param name="scanId"> The scanId. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics;
        private readonly DatabaseVulnerabilityAssessmentScansRestOperations _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient;
        private readonly VulnerabilityAssessmentScanRecordData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Sql/servers/databases/vulnerabilityAssessments/scans";

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> class for mocking. </summary>
        protected SqlDatabaseVulnerabilityAssessmentScanResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentScanResource(ArmClient client, VulnerabilityAssessmentScanRecordData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentScanResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansApiVersion);
            _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient = new DatabaseVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual VulnerabilityAssessmentScanRecordData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseVulnerabilityAssessmentScanResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseVulnerabilityAssessmentScanResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanResource.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Executes a Vulnerability Assessment database scan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_InitiateScan</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> InitiateScanAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanResource.InitiateScan");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.InitiateScanAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new SqlArmOperation(_sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics, Pipeline, _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.CreateInitiateScanRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Executes a Vulnerability Assessment database scan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/initiateScan</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_InitiateScan</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation InitiateScan(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanResource.InitiateScan");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.InitiateScan(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                var operation = new SqlArmOperation(_sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics, Pipeline, _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.CreateInitiateScanRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Convert an existing scan result to a human readable format. If already exists nothing happens
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Export</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DatabaseVulnerabilityAssessmentScansExport>> ExportAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanResource.Export");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.ExportAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Convert an existing scan result to a human readable format. If already exists nothing happens
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}/export</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Export</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DatabaseVulnerabilityAssessmentScansExport> Export(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanResource.Export");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.Export(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
