// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> and their operations.
    /// Each <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> in the collection will belong to the same instance of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SqlDatabaseVulnerabilityAssessmentScanCollection"/> instance call the GetSqlDatabaseVulnerabilityAssessmentScans method from an instance of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SqlDatabaseVulnerabilityAssessmentScanCollection : ArmCollection, IEnumerable<SqlDatabaseVulnerabilityAssessmentScanResource>, IAsyncEnumerable<SqlDatabaseVulnerabilityAssessmentScanResource>
    {
        private readonly ClientDiagnostics _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics;
        private readonly DatabaseVulnerabilityAssessmentScansRestOperations _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentScanCollection"/> class for mocking. </summary>
        protected SqlDatabaseVulnerabilityAssessmentScanCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentScanCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentScanCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlDatabaseVulnerabilityAssessmentScanResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlDatabaseVulnerabilityAssessmentScanResource.ResourceType, out string sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansApiVersion);
            _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient = new DatabaseVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlDatabaseVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlDatabaseVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<SqlDatabaseVulnerabilityAssessmentScanResource>> GetAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a vulnerability assessment scan record of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<SqlDatabaseVulnerabilityAssessmentScanResource> Get(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlDatabaseVulnerabilityAssessmentScanResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseVulnerabilityAssessmentScanResource(Client, VulnerabilityAssessmentScanRecordData.DeserializeVulnerabilityAssessmentScanRecordData(e)), _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SqlDatabaseVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlDatabaseVulnerabilityAssessmentScanResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseVulnerabilityAssessmentScanResource(Client, VulnerabilityAssessmentScanRecordData.DeserializeVulnerabilityAssessmentScanRecordData(e)), _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SqlDatabaseVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlDatabaseVulnerabilityAssessmentScanResource>> GetIfExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual NullableResponse<SqlDatabaseVulnerabilityAssessmentScanResource> GetIfExists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentScanDatabaseVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlDatabaseVulnerabilityAssessmentScanResource> IEnumerable<SqlDatabaseVulnerabilityAssessmentScanResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlDatabaseVulnerabilityAssessmentScanResource> IAsyncEnumerable<SqlDatabaseVulnerabilityAssessmentScanResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
