// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A Class representing a SqlDatabaseVulnerabilityAssessmentRuleBaseline along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlDatabaseVulnerabilityAssessmentRuleBaselineResource method.
    /// Otherwise you can get one from its parent resource <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> using the GetSqlDatabaseVulnerabilityAssessmentRuleBaseline method.
    /// </summary>
    public partial class SqlDatabaseVulnerabilityAssessmentRuleBaselineResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="serverName"> The serverName. </param>
        /// <param name="databaseName"> The databaseName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        /// <param name="ruleId"> The ruleId. </param>
        /// <param name="baselineName"> The baselineName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics;
        private readonly DatabaseVulnerabilityAssessmentRuleBaselinesRestOperations _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient;
        private readonly DatabaseVulnerabilityAssessmentRuleBaselineData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Sql/servers/databases/vulnerabilityAssessments/rules/baselines";

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> class for mocking. </summary>
        protected SqlDatabaseVulnerabilityAssessmentRuleBaselineResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(ArmClient client, DatabaseVulnerabilityAssessmentRuleBaselineData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesApiVersion);
            _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient = new DatabaseVulnerabilityAssessmentRuleBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual DatabaseVulnerabilityAssessmentRuleBaselineData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes the database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> DeleteAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.Delete");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.DeleteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), cancellationToken).ConfigureAwait(false);
                var uri = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName());
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes the database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Delete</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation Delete(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.Delete");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.Delete(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), cancellationToken);
                var uri = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateDeleteRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName());
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Delete, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation(response, rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>> UpdateAsync(WaitUntil waitUntil, DatabaseVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.Update");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), data, cancellationToken).ConfigureAwait(false);
                var uri = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource> Update(WaitUntil waitUntil, DatabaseVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.Update");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), data, cancellationToken);
                var uri = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Parent.Name, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name.ToVulnerabilityAssessmentPolicyBaselineName(), data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
