// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> and their operations.
    /// Each <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/> in the collection will belong to the same instance of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection"/> instance call the GetSqlDatabaseVulnerabilityAssessmentRuleBaselines method from an instance of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection : ArmCollection
    {
        private readonly ClientDiagnostics _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics;
        private readonly DatabaseVulnerabilityAssessmentRuleBaselinesRestOperations _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection"/> class for mocking. </summary>
        protected SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlDatabaseVulnerabilityAssessmentRuleBaselineResource.ResourceType, out string sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesApiVersion);
            _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient = new DatabaseVulnerabilityAssessmentRuleBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlDatabaseVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlDatabaseVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>> CreateOrUpdateAsync(WaitUntil waitUntil, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data, cancellationToken).ConfigureAwait(false);
                var uri = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource> CreateOrUpdate(WaitUntil waitUntil, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data, cancellationToken);
                var uri = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>(Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<Response<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>> GetAsync(string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a database's vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual Response<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource> Get(string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual Response<bool> Exists(string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>> GetIfExistsAsync(string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentRuleBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        public virtual NullableResponse<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource> GetIfExists(string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var scope = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentRuleBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentRuleBaselineDatabaseVulnerabilityAssessmentRuleBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, ruleId, baselineName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseVulnerabilityAssessmentRuleBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentRuleBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
