// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> and their operations.
    /// Each <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> in the collection will belong to the same instance of <see cref="SqlDatabaseResource"/>.
    /// To get a <see cref="SqlDatabaseVulnerabilityAssessmentCollection"/> instance call the GetSqlDatabaseVulnerabilityAssessments method from an instance of <see cref="SqlDatabaseResource"/>.
    /// </summary>
    public partial class SqlDatabaseVulnerabilityAssessmentCollection : ArmCollection, IEnumerable<SqlDatabaseVulnerabilityAssessmentResource>, IAsyncEnumerable<SqlDatabaseVulnerabilityAssessmentResource>
    {
        private readonly ClientDiagnostics _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics;
        private readonly DatabaseVulnerabilityAssessmentsRestOperations _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentCollection"/> class for mocking. </summary>
        protected SqlDatabaseVulnerabilityAssessmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseVulnerabilityAssessmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlDatabaseVulnerabilityAssessmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlDatabaseVulnerabilityAssessmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlDatabaseVulnerabilityAssessmentResource.ResourceType, out string sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsApiVersion);
            _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient = new DatabaseVulnerabilityAssessmentsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlDatabaseResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlDatabaseResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Creates or updates the database's vulnerability assessment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="data"> The requested resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlDatabaseVulnerabilityAssessmentResource>> CreateOrUpdateAsync(WaitUntil waitUntil, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, data, cancellationToken).ConfigureAwait(false);
                var uri = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseVulnerabilityAssessmentResource>(Response.FromValue(new SqlDatabaseVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Creates or updates the database's vulnerability assessment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="data"> The requested resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="data"/> is null. </exception>
        public virtual ArmOperation<SqlDatabaseVulnerabilityAssessmentResource> CreateOrUpdate(WaitUntil waitUntil, VulnerabilityAssessmentName vulnerabilityAssessmentName, DatabaseVulnerabilityAssessmentData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(data, nameof(data));

            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, data, cancellationToken);
                var uri = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, data);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseVulnerabilityAssessmentResource>(Response.FromValue(new SqlDatabaseVulnerabilityAssessmentResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the database's vulnerability assessment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseVulnerabilityAssessmentResource>> GetAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets the database's vulnerability assessment.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseVulnerabilityAssessmentResource> Get(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the vulnerability assessment policies associated with a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlDatabaseVulnerabilityAssessmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseVulnerabilityAssessmentResource(Client, DatabaseVulnerabilityAssessmentData.DeserializeDatabaseVulnerabilityAssessmentData(e)), _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics, Pipeline, "SqlDatabaseVulnerabilityAssessmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the vulnerability assessment policies associated with a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlDatabaseVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlDatabaseVulnerabilityAssessmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseVulnerabilityAssessmentResource(Client, DatabaseVulnerabilityAssessmentData.DeserializeDatabaseVulnerabilityAssessmentData(e)), _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics, Pipeline, "SqlDatabaseVulnerabilityAssessmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SqlDatabaseVulnerabilityAssessmentResource>> GetIfExistsAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseVulnerabilityAssessments_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2020-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SqlDatabaseVulnerabilityAssessmentResource> GetIfExists(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsClientDiagnostics.CreateScope("SqlDatabaseVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseVulnerabilityAssessmentDatabaseVulnerabilityAssessmentsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlDatabaseVulnerabilityAssessmentResource> IEnumerable<SqlDatabaseVulnerabilityAssessmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlDatabaseVulnerabilityAssessmentResource> IAsyncEnumerable<SqlDatabaseVulnerabilityAssessmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
