// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> and their operations.
    /// Each <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> in the collection will belong to the same instance of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanCollection"/> instance call the GetSqlDatabaseSqlVulnerabilityAssessmentScans method from an instance of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SqlDatabaseSqlVulnerabilityAssessmentScanCollection : ArmCollection, IEnumerable<SqlDatabaseSqlVulnerabilityAssessmentScanResource>, IAsyncEnumerable<SqlDatabaseSqlVulnerabilityAssessmentScanResource>
    {
        private readonly ClientDiagnostics _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics;
        private readonly DatabaseSqlVulnerabilityAssessmentScansRestOperations _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanCollection"/> class for mocking. </summary>
        protected SqlDatabaseSqlVulnerabilityAssessmentScanCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentScanCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlDatabaseSqlVulnerabilityAssessmentScanResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlDatabaseSqlVulnerabilityAssessmentScanResource.ResourceType, out string sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansApiVersion);
            _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient = new DatabaseSqlVulnerabilityAssessmentScansRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlDatabaseSqlVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlDatabaseSqlVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Get a database vulnerability assessment scan result.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentScanResource>> GetAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get a database vulnerability assessment scan result.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentScanResource> Get(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentScanCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_ListBySqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlDatabaseSqlVulnerabilityAssessmentScanResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, SqlVulnerabilityAssessmentScanData.DeserializeSqlVulnerabilityAssessmentScanData(e)), _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SqlDatabaseSqlVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists the vulnerability assessment scans of a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_ListBySqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlDatabaseSqlVulnerabilityAssessmentScanResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.CreateListBySqlVulnerabilityAssessmentsNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, SqlVulnerabilityAssessmentScanData.DeserializeSqlVulnerabilityAssessmentScanData(e)), _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics, Pipeline, "SqlDatabaseSqlVulnerabilityAssessmentScanCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<Response<bool>> ExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual Response<bool> Exists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentScanCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual async Task<NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentScanResource>> GetIfExistsAsync(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseSqlVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        public virtual NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentScanResource> GetIfExists(string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentScanCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentScanDatabaseSqlVulnerabilityAssessmentScansRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, scanId, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseSqlVulnerabilityAssessmentScanResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentScanResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlDatabaseSqlVulnerabilityAssessmentScanResource> IEnumerable<SqlDatabaseSqlVulnerabilityAssessmentScanResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlDatabaseSqlVulnerabilityAssessmentScanResource> IAsyncEnumerable<SqlDatabaseSqlVulnerabilityAssessmentScanResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
