// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A Class representing a SqlDatabaseSqlVulnerabilityAssessment along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlDatabaseSqlVulnerabilityAssessmentResource method.
    /// Otherwise you can get one from its parent resource <see cref="SqlDatabaseResource"/> using the GetSqlDatabaseSqlVulnerabilityAssessment method.
    /// </summary>
    public partial class SqlDatabaseSqlVulnerabilityAssessmentResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="serverName"> The serverName. </param>
        /// <param name="databaseName"> The databaseName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics;
        private readonly DatabaseSqlVulnerabilityAssessmentsSettingsRestOperations _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient;
        private readonly ClientDiagnostics _databaseSqlVulnerabilityAssessmentExecuteScanClientDiagnostics;
        private readonly DatabaseSqlVulnerabilityAssessmentExecuteScanRestOperations _databaseSqlVulnerabilityAssessmentExecuteScanRestClient;
        private readonly SqlVulnerabilityAssessmentData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments";

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> class for mocking. </summary>
        protected SqlDatabaseSqlVulnerabilityAssessmentResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentResource(ArmClient client, SqlVulnerabilityAssessmentData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsApiVersion);
            _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient = new DatabaseSqlVulnerabilityAssessmentsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsApiVersion);
            _databaseSqlVulnerabilityAssessmentExecuteScanClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ProviderConstants.DefaultProviderNamespace, Diagnostics);
            _databaseSqlVulnerabilityAssessmentExecuteScanRestClient = new DatabaseSqlVulnerabilityAssessmentExecuteScanRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SqlVulnerabilityAssessmentData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of SqlDatabaseSqlVulnerabilityAssessmentBaselineResources in the SqlDatabaseSqlVulnerabilityAssessment. </summary>
        /// <returns> An object representing collection of SqlDatabaseSqlVulnerabilityAssessmentBaselineResources and their operations over a SqlDatabaseSqlVulnerabilityAssessmentBaselineResource. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection GetSqlDatabaseSqlVulnerabilityAssessmentBaselines()
        {
            return GetCachedClient(client => new SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection(client, Id));
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>> GetSqlDatabaseSqlVulnerabilityAssessmentBaselineAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            return await GetSqlDatabaseSqlVulnerabilityAssessmentBaselines().GetAsync(baselineName, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        [ForwardsClientCalls]
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> GetSqlDatabaseSqlVulnerabilityAssessmentBaseline(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            return GetSqlDatabaseSqlVulnerabilityAssessmentBaselines().Get(baselineName, cancellationToken);
        }

        /// <summary> Gets a collection of SqlDatabaseSqlVulnerabilityAssessmentScanResources in the SqlDatabaseSqlVulnerabilityAssessment. </summary>
        /// <returns> An object representing collection of SqlDatabaseSqlVulnerabilityAssessmentScanResources and their operations over a SqlDatabaseSqlVulnerabilityAssessmentScanResource. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentScanCollection GetSqlDatabaseSqlVulnerabilityAssessmentScans()
        {
            return GetCachedClient(client => new SqlDatabaseSqlVulnerabilityAssessmentScanCollection(client, Id));
        }

        /// <summary>
        /// Get a database vulnerability assessment scan result.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentScanResource>> GetSqlDatabaseSqlVulnerabilityAssessmentScanAsync(string scanId, CancellationToken cancellationToken = default)
        {
            return await GetSqlDatabaseSqlVulnerabilityAssessmentScans().GetAsync(scanId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Get a database vulnerability assessment scan result.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/scans/{scanId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentScans_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentScanResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scanId"> The vulnerability assessment scan Id of the scan to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentScanResource> GetSqlDatabaseSqlVulnerabilityAssessmentScan(string scanId, CancellationToken cancellationToken = default)
        {
            return GetSqlDatabaseSqlVulnerabilityAssessmentScans().Get(scanId, cancellationToken);
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy for database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy for database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentResource.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Executes a Vulnerability Assessment database scan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/initiateScan</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentExecuteScan_Execute</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<ArmOperation> ExecuteScanAsync(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _databaseSqlVulnerabilityAssessmentExecuteScanClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentResource.ExecuteScan");
            scope.Start();
            try
            {
                var response = await _databaseSqlVulnerabilityAssessmentExecuteScanRestClient.ExecuteAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                var operation = new SqlArmOperation(_databaseSqlVulnerabilityAssessmentExecuteScanClientDiagnostics, Pipeline, _databaseSqlVulnerabilityAssessmentExecuteScanRestClient.CreateExecuteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionResponseAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Executes a Vulnerability Assessment database scan.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/initiateScan</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentExecuteScan_Execute</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual ArmOperation ExecuteScan(WaitUntil waitUntil, CancellationToken cancellationToken = default)
        {
            using var scope = _databaseSqlVulnerabilityAssessmentExecuteScanClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentResource.ExecuteScan");
            scope.Start();
            try
            {
                var response = _databaseSqlVulnerabilityAssessmentExecuteScanRestClient.Execute(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                var operation = new SqlArmOperation(_databaseSqlVulnerabilityAssessmentExecuteScanClientDiagnostics, Pipeline, _databaseSqlVulnerabilityAssessmentExecuteScanRestClient.CreateExecuteRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name).Request, response, OperationFinalStateVia.Location);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletionResponse(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
