// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> and their operations.
    /// Each <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> in the collection will belong to the same instance of <see cref="SqlDatabaseResource"/>.
    /// To get a <see cref="SqlDatabaseSqlVulnerabilityAssessmentCollection"/> instance call the GetSqlDatabaseSqlVulnerabilityAssessments method from an instance of <see cref="SqlDatabaseResource"/>.
    /// </summary>
    public partial class SqlDatabaseSqlVulnerabilityAssessmentCollection : ArmCollection, IEnumerable<SqlDatabaseSqlVulnerabilityAssessmentResource>, IAsyncEnumerable<SqlDatabaseSqlVulnerabilityAssessmentResource>
    {
        private readonly ClientDiagnostics _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics;
        private readonly DatabaseSqlVulnerabilityAssessmentsSettingsRestOperations _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentCollection"/> class for mocking. </summary>
        protected SqlDatabaseSqlVulnerabilityAssessmentCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlDatabaseSqlVulnerabilityAssessmentResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlDatabaseSqlVulnerabilityAssessmentResource.ResourceType, out string sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsApiVersion);
            _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient = new DatabaseSqlVulnerabilityAssessmentsSettingsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlDatabaseResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlDatabaseResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy for database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentResource>> GetAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets SQL Vulnerability Assessment policy for database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentResource> Get(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Lists SQL Vulnerability Assessment policies associated with a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlDatabaseSqlVulnerabilityAssessmentResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, SqlVulnerabilityAssessmentData.DeserializeSqlVulnerabilityAssessmentData(e)), _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics, Pipeline, "SqlDatabaseSqlVulnerabilityAssessmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Lists SQL Vulnerability Assessment policies associated with a database.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_ListByDatabase</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlDatabaseSqlVulnerabilityAssessmentResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByDatabaseRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.CreateListByDatabaseNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, SqlVulnerabilityAssessmentData.DeserializeSqlVulnerabilityAssessmentData(e)), _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics, Pipeline, "SqlDatabaseSqlVulnerabilityAssessmentCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentResource>> GetIfExistsAsync(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseSqlVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentsSettings_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentResource> GetIfExists(VulnerabilityAssessmentName vulnerabilityAssessmentName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentDatabaseSqlVulnerabilityAssessmentsSettingsRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Name, Id.Name, vulnerabilityAssessmentName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseSqlVulnerabilityAssessmentResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlDatabaseSqlVulnerabilityAssessmentResource> IEnumerable<SqlDatabaseSqlVulnerabilityAssessmentResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlDatabaseSqlVulnerabilityAssessmentResource> IAsyncEnumerable<SqlDatabaseSqlVulnerabilityAssessmentResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
