// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A Class representing a SqlDatabaseSqlVulnerabilityAssessmentBaseline along with the instance operations that can be performed on it.
    /// If you have a <see cref="ResourceIdentifier"/> you can construct a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/>
    /// from an instance of <see cref="ArmClient"/> using the GetSqlDatabaseSqlVulnerabilityAssessmentBaselineResource method.
    /// Otherwise you can get one from its parent resource <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/> using the GetSqlDatabaseSqlVulnerabilityAssessmentBaseline method.
    /// </summary>
    public partial class SqlDatabaseSqlVulnerabilityAssessmentBaselineResource : ArmResource
    {
        /// <summary> Generate the resource identifier of a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> instance. </summary>
        /// <param name="subscriptionId"> The subscriptionId. </param>
        /// <param name="resourceGroupName"> The resourceGroupName. </param>
        /// <param name="serverName"> The serverName. </param>
        /// <param name="databaseName"> The databaseName. </param>
        /// <param name="vulnerabilityAssessmentName"> The vulnerabilityAssessmentName. </param>
        /// <param name="baselineName"> The baselineName. </param>
        public static ResourceIdentifier CreateResourceIdentifier(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName)
        {
            var resourceId = $"/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}";
            return new ResourceIdentifier(resourceId);
        }

        private readonly ClientDiagnostics _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics;
        private readonly DatabaseSqlVulnerabilityAssessmentBaselinesRestOperations _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient;
        private readonly SqlVulnerabilityAssessmentBaselineData _data;

        /// <summary> Gets the resource type for the operations. </summary>
        public static readonly ResourceType ResourceType = "Microsoft.Sql/servers/databases/sqlVulnerabilityAssessments/baselines";

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> class for mocking. </summary>
        protected SqlDatabaseSqlVulnerabilityAssessmentBaselineResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="data"> The resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(ArmClient client, SqlVulnerabilityAssessmentBaselineData data) : this(client, data.Id)
        {
            HasData = true;
            _data = data;
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(ResourceType, out string sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesApiVersion);
            _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient = new DatabaseSqlVulnerabilityAssessmentBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        /// <summary> Gets whether or not the current instance has data. </summary>
        public virtual bool HasData { get; }

        /// <summary> Gets the data representing this Feature. </summary>
        /// <exception cref="InvalidOperationException"> Throws if there is no data loaded in the current instance. </exception>
        public virtual SqlVulnerabilityAssessmentBaselineData Data
        {
            get
            {
                if (!HasData)
                    throw new InvalidOperationException("The current instance does not have data, you must call Get first.");
                return _data;
            }
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, ResourceType), nameof(id));
        }

        /// <summary> Gets a collection of SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResources in the SqlDatabaseSqlVulnerabilityAssessmentBaseline. </summary>
        /// <returns> An object representing collection of SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResources and their operations over a SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource. </returns>
        public virtual SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleCollection GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRules()
        {
            return GetCachedClient(client => new SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleCollection(client, Id));
        }

        /// <summary>
        /// Gets a database's sql vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource>> GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRuleAsync(string ruleId, CancellationToken cancellationToken = default)
        {
            return await GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRules().GetAsync(ruleId, cancellationToken).ConfigureAwait(false);
        }

        /// <summary>
        /// Gets a database's sql vulnerability assessment rule baseline.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}/rules/{ruleId}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentRuleBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        [ForwardsClientCalls]
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineRuleResource> GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRule(string ruleId, CancellationToken cancellationToken = default)
        {
            return GetSqlDatabaseSqlVulnerabilityAssessmentBaselineRules().Get(ruleId, cancellationToken);
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>> GetAsync(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> Get(CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a database's vulnerability assessment rule baseline list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>> UpdateAsync(WaitUntil waitUntil, SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.Update");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, content, cancellationToken).ConfigureAwait(false);
                var uri = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>(Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a database's vulnerability assessment rule baseline list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> Update(WaitUntil waitUntil, SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.Update");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, content, cancellationToken);
                var uri = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Parent.Name, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>(Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
