// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections;
using System.Collections.Generic;
using System.Globalization;
using System.Threading;
using System.Threading.Tasks;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing a collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> and their operations.
    /// Each <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> in the collection will belong to the same instance of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/>.
    /// To get a <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection"/> instance call the GetSqlDatabaseSqlVulnerabilityAssessmentBaselines method from an instance of <see cref="SqlDatabaseSqlVulnerabilityAssessmentResource"/>.
    /// </summary>
    public partial class SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection : ArmCollection, IEnumerable<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>, IAsyncEnumerable<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>
    {
        private readonly ClientDiagnostics _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics;
        private readonly DatabaseSqlVulnerabilityAssessmentBaselinesRestOperations _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient;

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection"/> class for mocking. </summary>
        protected SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the parent resource that is the target of operations. </param>
        internal SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
            _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics = new ClientDiagnostics("Azure.ResourceManager.Sql", SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.ResourceType.Namespace, Diagnostics);
            TryGetApiVersion(SqlDatabaseSqlVulnerabilityAssessmentBaselineResource.ResourceType, out string sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesApiVersion);
            _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient = new DatabaseSqlVulnerabilityAssessmentBaselinesRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint, sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesApiVersion);
#if DEBUG
			ValidateResourceId(Id);
#endif
        }

        internal static void ValidateResourceId(ResourceIdentifier id)
        {
            if (id.ResourceType != SqlDatabaseSqlVulnerabilityAssessmentResource.ResourceType)
                throw new ArgumentException(string.Format(CultureInfo.CurrentCulture, "Invalid resource type {0} expected {1}", id.ResourceType, SqlDatabaseSqlVulnerabilityAssessmentResource.ResourceType), nameof(id));
        }

        /// <summary>
        /// Add a database's vulnerability assessment rule baseline list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual async Task<ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>> CreateOrUpdateAsync(WaitUntil waitUntil, SqlVulnerabilityAssessmentBaselineName baselineName, SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateOrUpdateAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, content, cancellationToken).ConfigureAwait(false);
                var uri = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>(Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    await operation.WaitForCompletionAsync(cancellationToken).ConfigureAwait(false);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Add a database's vulnerability assessment rule baseline list.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_CreateOrUpdate</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="waitUntil"> <see cref="WaitUntil.Completed"/> if the method should wait to return until the long-running operation has completed on the service; <see cref="WaitUntil.Started"/> if it should return after starting the operation. For more information on long-running operations, please see <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/LongRunningOperations.md"> Azure.Core Long-Running Operation samples</see>. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="content"/> is null. </exception>
        public virtual ArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> CreateOrUpdate(WaitUntil waitUntil, SqlVulnerabilityAssessmentBaselineName baselineName, SqlVulnerabilityAssessmentBaselineCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(content, nameof(content));

            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.CreateOrUpdate");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateOrUpdate(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, content, cancellationToken);
                var uri = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateCreateOrUpdateRequestUri(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, content);
                var rehydrationToken = NextLinkOperationImplementation.GetRehydrationToken(RequestMethod.Put, uri.ToUri(), uri.ToString(), "None", null, OperationFinalStateVia.OriginalUri.ToString());
                var operation = new SqlArmOperation<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>(Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response), response.GetRawResponse()), rehydrationToken);
                if (waitUntil == WaitUntil.Completed)
                    operation.WaitForCompletion(cancellationToken);
                return operation;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>> GetAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> Get(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.Get");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, cancellationToken);
                if (response.Value == null)
                    throw new RequestFailedException(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_ListBySqlVulnerabilityAssessment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> An async collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual AsyncPageable<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> GetAllAsync(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateListBySqlVulnerabilityAssessmentRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateListBySqlVulnerabilityAssessmentNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, SqlVulnerabilityAssessmentBaselineData.DeserializeSqlVulnerabilityAssessmentBaselineData(e)), _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics, Pipeline, "SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Gets a list of database's sql vulnerability assessment rule baselines.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_ListBySqlVulnerabilityAssessment</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <returns> A collection of <see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/> that may take multiple service requests to iterate over. </returns>
        public virtual Pageable<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> GetAll(CancellationToken cancellationToken = default)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateListBySqlVulnerabilityAssessmentRequest(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.CreateListBySqlVulnerabilityAssessmentNextPageRequest(nextLink, Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, SqlVulnerabilityAssessmentBaselineData.DeserializeSqlVulnerabilityAssessmentBaselineData(e)), _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics, Pipeline, "SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.GetAll", "value", "nextLink", cancellationToken);
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<bool>> ExistsAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Checks to see if the resource exists in azure.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<bool> Exists(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.Exists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken);
                return Response.FromValue(response.Value != null, response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>> GetIfExistsAsync(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = await _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.GetAsync(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken).ConfigureAwait(false);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Tries to get details for this resource from the service.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/servers/{serverName}/databases/{databaseName}/sqlVulnerabilityAssessments/{vulnerabilityAssessmentName}/baselines/{baselineName}</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DatabaseSqlVulnerabilityAssessmentBaselines_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2022-11-01-preview</description>
        /// </item>
        /// <item>
        /// <term>Resource</term>
        /// <description><see cref="SqlDatabaseSqlVulnerabilityAssessmentBaselineResource"/></description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual NullableResponse<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> GetIfExists(SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            using var scope = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesClientDiagnostics.CreateScope("SqlDatabaseSqlVulnerabilityAssessmentBaselineCollection.GetIfExists");
            scope.Start();
            try
            {
                var response = _sqlDatabaseSqlVulnerabilityAssessmentBaselineDatabaseSqlVulnerabilityAssessmentBaselinesRestClient.Get(Id.SubscriptionId, Id.ResourceGroupName, Id.Parent.Parent.Name, Id.Parent.Name, Id.Name, baselineName, cancellationToken: cancellationToken);
                if (response.Value == null)
                    return new NoValueResponse<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>(response.GetRawResponse());
                return Response.FromValue(new SqlDatabaseSqlVulnerabilityAssessmentBaselineResource(Client, response.Value), response.GetRawResponse());
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        IEnumerator<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> IEnumerable<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return GetAll().GetEnumerator();
        }

        IAsyncEnumerator<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource> IAsyncEnumerable<SqlDatabaseSqlVulnerabilityAssessmentBaselineResource>.GetAsyncEnumerator(CancellationToken cancellationToken)
        {
            return GetAllAsync(cancellationToken: cancellationToken).GetAsyncEnumerator(cancellationToken);
        }
    }
}
