// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the SqlDatabaseAutomaticTuning data model.
    /// Database-level Automatic Tuning.
    /// </summary>
    public partial class SqlDatabaseAutomaticTuningData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SqlDatabaseAutomaticTuningData"/>. </summary>
        public SqlDatabaseAutomaticTuningData()
        {
            Options = new ChangeTrackingDictionary<string, AutomaticTuningOptions>();
        }

        /// <summary> Initializes a new instance of <see cref="SqlDatabaseAutomaticTuningData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="desiredState"> Automatic tuning desired state. </param>
        /// <param name="actualState"> Automatic tuning actual state. </param>
        /// <param name="options"> Automatic tuning options definition. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SqlDatabaseAutomaticTuningData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, AutomaticTuningMode? desiredState, AutomaticTuningMode? actualState, IDictionary<string, AutomaticTuningOptions> options, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            DesiredState = desiredState;
            ActualState = actualState;
            Options = options;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Automatic tuning desired state. </summary>
        [WirePath("properties.desiredState")]
        public AutomaticTuningMode? DesiredState { get; set; }
        /// <summary> Automatic tuning actual state. </summary>
        [WirePath("properties.actualState")]
        public AutomaticTuningMode? ActualState { get; }
        /// <summary> Automatic tuning options definition. </summary>
        [WirePath("properties.options")]
        public IDictionary<string, AutomaticTuningOptions> Options { get; }
    }
}
