// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    public partial class SqlAdvisorData : IUtf8JsonSerializable, IJsonModel<SqlAdvisorData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SqlAdvisorData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SqlAdvisorData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlAdvisorData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlAdvisorData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind);
            }
            if (options.Format != "W" && Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(AdvisorStatus))
            {
                writer.WritePropertyName("advisorStatus"u8);
                writer.WriteStringValue(AdvisorStatus.Value.ToSerialString());
            }
            if (Optional.IsDefined(AutoExecuteStatus))
            {
                writer.WritePropertyName("autoExecuteStatus"u8);
                writer.WriteStringValue(AutoExecuteStatus.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(AutoExecuteStatusInheritedFrom))
            {
                writer.WritePropertyName("autoExecuteStatusInheritedFrom"u8);
                writer.WriteStringValue(AutoExecuteStatusInheritedFrom.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(RecommendationsStatus))
            {
                writer.WritePropertyName("recommendationsStatus"u8);
                writer.WriteStringValue(RecommendationsStatus);
            }
            if (options.Format != "W" && Optional.IsDefined(LastCheckedOn))
            {
                writer.WritePropertyName("lastChecked"u8);
                writer.WriteStringValue(LastCheckedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(RecommendedActions))
            {
                writer.WritePropertyName("recommendedActions"u8);
                writer.WriteStartArray();
                foreach (var item in RecommendedActions)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            writer.WriteEndObject();
        }

        SqlAdvisorData IJsonModel<SqlAdvisorData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlAdvisorData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SqlAdvisorData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSqlAdvisorData(document.RootElement, options);
        }

        internal static SqlAdvisorData DeserializeSqlAdvisorData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string kind = default;
            AzureLocation? location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            SqlAdvisorStatus? advisorStatus = default;
            AutoExecuteStatus? autoExecuteStatus = default;
            AutoExecuteStatusInheritedFrom? autoExecuteStatusInheritedFrom = default;
            string recommendationsStatus = default;
            DateTimeOffset? lastChecked = default;
            IReadOnlyList<RecommendedActionData> recommendedActions = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    kind = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("advisorStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            advisorStatus = property0.Value.GetString().ToSqlAdvisorStatus();
                            continue;
                        }
                        if (property0.NameEquals("autoExecuteStatus"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoExecuteStatus = property0.Value.GetString().ToAutoExecuteStatus();
                            continue;
                        }
                        if (property0.NameEquals("autoExecuteStatusInheritedFrom"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            autoExecuteStatusInheritedFrom = property0.Value.GetString().ToAutoExecuteStatusInheritedFrom();
                            continue;
                        }
                        if (property0.NameEquals("recommendationsStatus"u8))
                        {
                            recommendationsStatus = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("lastChecked"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastChecked = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("recommendedActions"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<RecommendedActionData> array = new List<RecommendedActionData>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(RecommendedActionData.DeserializeRecommendedActionData(item, options));
                            }
                            recommendedActions = array;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SqlAdvisorData(
                id,
                name,
                type,
                systemData,
                kind,
                location,
                advisorStatus,
                autoExecuteStatus,
                autoExecuteStatusInheritedFrom,
                recommendationsStatus,
                lastChecked,
                recommendedActions ?? new ChangeTrackingList<RecommendedActionData>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Location))
                {
                    builder.Append("  location: ");
                    builder.AppendLine($"'{Location.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Kind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Kind))
                {
                    builder.Append("  kind: ");
                    if (Kind.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Kind}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Kind}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AdvisorStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    advisorStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AdvisorStatus))
                {
                    builder.Append("    advisorStatus: ");
                    builder.AppendLine($"'{AdvisorStatus.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoExecuteStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    autoExecuteStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoExecuteStatus))
                {
                    builder.Append("    autoExecuteStatus: ");
                    builder.AppendLine($"'{AutoExecuteStatus.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AutoExecuteStatusInheritedFrom), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    autoExecuteStatusInheritedFrom: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AutoExecuteStatusInheritedFrom))
                {
                    builder.Append("    autoExecuteStatusInheritedFrom: ");
                    builder.AppendLine($"'{AutoExecuteStatusInheritedFrom.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RecommendationsStatus), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    recommendationsStatus: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RecommendationsStatus))
                {
                    builder.Append("    recommendationsStatus: ");
                    if (RecommendationsStatus.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RecommendationsStatus}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RecommendationsStatus}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastCheckedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastChecked: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastCheckedOn))
                {
                    builder.Append("    lastChecked: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastCheckedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RecommendedActions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    recommendedActions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(RecommendedActions))
                {
                    if (RecommendedActions.Any())
                    {
                        builder.Append("    recommendedActions: ");
                        builder.AppendLine("[");
                        foreach (var item in RecommendedActions)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    recommendedActions: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SqlAdvisorData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlAdvisorData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SqlAdvisorData)} does not support writing '{options.Format}' format.");
            }
        }

        SqlAdvisorData IPersistableModel<SqlAdvisorData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SqlAdvisorData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSqlAdvisorData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SqlAdvisorData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SqlAdvisorData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
