// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the SensitivityLabel data model.
    /// A sensitivity label.
    /// </summary>
    public partial class SensitivityLabelData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SensitivityLabelData"/>. </summary>
        public SensitivityLabelData()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SensitivityLabelData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="managedBy"> Resource that manages the sensitivity label. </param>
        /// <param name="schemaName"> The schema name. </param>
        /// <param name="tableName"> The table name. </param>
        /// <param name="columnName"> The column name. </param>
        /// <param name="labelName"> The label name. </param>
        /// <param name="labelId"> The label ID. </param>
        /// <param name="informationType"> The information type. </param>
        /// <param name="informationTypeId"> The information type ID. </param>
        /// <param name="isDisabled"> Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not. </param>
        /// <param name="rank"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SensitivityLabelData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string managedBy, string schemaName, string tableName, string columnName, string labelName, string labelId, string informationType, string informationTypeId, bool? isDisabled, SensitivityLabelRank? rank, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            ManagedBy = managedBy;
            SchemaName = schemaName;
            TableName = tableName;
            ColumnName = columnName;
            LabelName = labelName;
            LabelId = labelId;
            InformationType = informationType;
            InformationTypeId = informationTypeId;
            IsDisabled = isDisabled;
            Rank = rank;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource that manages the sensitivity label. </summary>
        [WirePath("managedBy")]
        public string ManagedBy { get; }
        /// <summary> The schema name. </summary>
        [WirePath("properties.schemaName")]
        public string SchemaName { get; }
        /// <summary> The table name. </summary>
        [WirePath("properties.tableName")]
        public string TableName { get; }
        /// <summary> The column name. </summary>
        [WirePath("properties.columnName")]
        public string ColumnName { get; }
        /// <summary> The label name. </summary>
        [WirePath("properties.labelName")]
        public string LabelName { get; set; }
        /// <summary> The label ID. </summary>
        [WirePath("properties.labelId")]
        public string LabelId { get; set; }
        /// <summary> The information type. </summary>
        [WirePath("properties.informationType")]
        public string InformationType { get; set; }
        /// <summary> The information type ID. </summary>
        [WirePath("properties.informationTypeId")]
        public string InformationTypeId { get; set; }
        /// <summary> Is sensitivity recommendation disabled. Applicable for recommended sensitivity label only. Specifies whether the sensitivity recommendation on this column is disabled (dismissed) or not. </summary>
        [WirePath("properties.isDisabled")]
        public bool? IsDisabled { get; }
        /// <summary> Gets or sets the rank. </summary>
        [WirePath("properties.rank")]
        public SensitivityLabelRank? Rank { get; set; }
    }
}
