// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the RestorableDroppedDatabase data model.
    /// A restorable dropped database resource.
    /// </summary>
    public partial class RestorableDroppedDatabaseData : TrackedResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RestorableDroppedDatabaseData"/>. </summary>
        /// <param name="location"> The location. </param>
        public RestorableDroppedDatabaseData(AzureLocation location) : base(location)
        {
            Keys = new ChangeTrackingDictionary<string, SqlDatabaseKey>();
        }

        /// <summary> Initializes a new instance of <see cref="RestorableDroppedDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="sku"> The name and tier of the SKU. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="maxSizeBytes"> The max size of the database expressed in bytes. </param>
        /// <param name="createdOn"> The creation date of the database (ISO8601 format). </param>
        /// <param name="deletedOn"> The deletion date of the database (ISO8601 format). </param>
        /// <param name="earliestRestoreOn"> The earliest restore date of the database (ISO8601 format). </param>
        /// <param name="backupStorageRedundancy"> The storage account type used to store backups for this database. </param>
        /// <param name="keys"> The resource ids of the user assigned identities to use. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RestorableDroppedDatabaseData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, SqlSku sku, string databaseName, long? maxSizeBytes, DateTimeOffset? createdOn, DateTimeOffset? deletedOn, DateTimeOffset? earliestRestoreOn, SqlBackupStorageRedundancy? backupStorageRedundancy, IDictionary<string, SqlDatabaseKey> keys, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData, tags, location)
        {
            Sku = sku;
            DatabaseName = databaseName;
            MaxSizeBytes = maxSizeBytes;
            CreatedOn = createdOn;
            DeletedOn = deletedOn;
            EarliestRestoreOn = earliestRestoreOn;
            BackupStorageRedundancy = backupStorageRedundancy;
            Keys = keys;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="RestorableDroppedDatabaseData"/> for deserialization. </summary>
        internal RestorableDroppedDatabaseData()
        {
        }

        /// <summary> The name and tier of the SKU. </summary>
        [WirePath("sku")]
        public SqlSku Sku { get; set; }
        /// <summary> The name of the database. </summary>
        [WirePath("properties.databaseName")]
        public string DatabaseName { get; }
        /// <summary> The max size of the database expressed in bytes. </summary>
        [WirePath("properties.maxSizeBytes")]
        public long? MaxSizeBytes { get; }
        /// <summary> The creation date of the database (ISO8601 format). </summary>
        [WirePath("properties.creationDate")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> The deletion date of the database (ISO8601 format). </summary>
        [WirePath("properties.deletionDate")]
        public DateTimeOffset? DeletedOn { get; }
        /// <summary> The earliest restore date of the database (ISO8601 format). </summary>
        [WirePath("properties.earliestRestoreDate")]
        public DateTimeOffset? EarliestRestoreOn { get; }
        /// <summary> The storage account type used to store backups for this database. </summary>
        [WirePath("properties.backupStorageRedundancy")]
        public SqlBackupStorageRedundancy? BackupStorageRedundancy { get; }
        /// <summary> The resource ids of the user assigned identities to use. </summary>
        [WirePath("properties.keys")]
        public IDictionary<string, SqlDatabaseKey> Keys { get; }
    }
}
