// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    internal partial class SqlVulnerabilityAssessmentScanResultRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of SqlVulnerabilityAssessmentScanResultRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public SqlVulnerabilityAssessmentScanResultRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-11-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListByScanRequestUri(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults", false);
            uri.AppendQuery("systemDatabaseName", "master", true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListByScanRequest(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults", false);
            uri.AppendQuery("systemDatabaseName", "master", true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a vulnerability assessment scan record of a database. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="scanId"> The scan id of the SQL Vulnerability Assessment scan to retrieve result from. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SqlVulnerabilityAssessmentScanListResult>> ListByScanAsync(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var message = CreateListByScanRequest(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SqlVulnerabilityAssessmentScanListResult.DeserializeSqlVulnerabilityAssessmentScanListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a vulnerability assessment scan record of a database. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="scanId"> The scan id of the SQL Vulnerability Assessment scan to retrieve result from. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SqlVulnerabilityAssessmentScanListResult> ListByScan(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var message = CreateListByScanRequest(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SqlVulnerabilityAssessmentScanListResult.DeserializeSqlVulnerabilityAssessmentScanListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, string scanResultId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults/", false);
            uri.AppendPath(scanResultId, true);
            uri.AppendQuery("systemDatabaseName", "master", true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, string scanResultId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/scans/", false);
            uri.AppendPath(scanId, true);
            uri.AppendPath("/scanResults/", false);
            uri.AppendPath(scanResultId, true);
            uri.AppendQuery("systemDatabaseName", "master", true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a vulnerability assessment scan record of a database. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="scanId"> The scan id of the SQL Vulnerability Assessment scan to retrieve result from. </param>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="scanId"/> or <paramref name="scanResultId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="scanId"/> or <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SqlVulnerabilityAssessmentScanResultData>> GetAsync(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, scanResultId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanResultData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SqlVulnerabilityAssessmentScanResultData.DeserializeSqlVulnerabilityAssessmentScanResultData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SqlVulnerabilityAssessmentScanResultData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a vulnerability assessment scan record of a database. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="scanId"> The scan id of the SQL Vulnerability Assessment scan to retrieve result from. </param>
        /// <param name="scanResultId"> The scan result id of the specific result to retrieve. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="scanId"/> or <paramref name="scanResultId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="scanId"/> or <paramref name="scanResultId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SqlVulnerabilityAssessmentScanResultData> Get(string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, string scanResultId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));
            Argument.AssertNotNullOrEmpty(scanResultId, nameof(scanResultId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId, scanResultId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanResultData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SqlVulnerabilityAssessmentScanResultData.DeserializeSqlVulnerabilityAssessmentScanResultData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SqlVulnerabilityAssessmentScanResultData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByScanNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListByScanNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a vulnerability assessment scan record of a database. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="scanId"> The scan id of the SQL Vulnerability Assessment scan to retrieve result from. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SqlVulnerabilityAssessmentScanListResult>> ListByScanNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var message = CreateListByScanNextPageRequest(nextLink, subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SqlVulnerabilityAssessmentScanListResult.DeserializeSqlVulnerabilityAssessmentScanListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a vulnerability assessment scan record of a database. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the SQL Vulnerability Assessment. </param>
        /// <param name="scanId"> The scan id of the SQL Vulnerability Assessment scan to retrieve result from. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="scanId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SqlVulnerabilityAssessmentScanListResult> ListByScanNextPage(string nextLink, string subscriptionId, string resourceGroupName, string serverName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string scanId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(scanId, nameof(scanId));

            using var message = CreateListByScanNextPageRequest(nextLink, subscriptionId, resourceGroupName, serverName, vulnerabilityAssessmentName, scanId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentScanListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SqlVulnerabilityAssessmentScanListResult.DeserializeSqlVulnerabilityAssessmentScanListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
