// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    internal partial class ManagedDatabaseVulnerabilityAssessmentRuleBaselinesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of ManagedDatabaseVulnerabilityAssessmentRuleBaselinesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public ManagedDatabaseVulnerabilityAssessmentRuleBaselinesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2020-11-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/managedInstances/", false);
            uri.AppendPath(managedInstanceName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/managedInstances/", false);
            uri.AppendPath(managedInstanceName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="managedInstanceName"> The name of the managed instance. </param>
        /// <param name="databaseName"> The name of the database for which the vulnerability assessment rule baseline is defined. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DatabaseVulnerabilityAssessmentRuleBaselineData>> GetAsync(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(managedInstanceName, nameof(managedInstanceName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DatabaseVulnerabilityAssessmentRuleBaselineData.DeserializeDatabaseVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((DatabaseVulnerabilityAssessmentRuleBaselineData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="managedInstanceName"> The name of the managed instance. </param>
        /// <param name="databaseName"> The name of the database for which the vulnerability assessment rule baseline is defined. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DatabaseVulnerabilityAssessmentRuleBaselineData> Get(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(managedInstanceName, nameof(managedInstanceName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DatabaseVulnerabilityAssessmentRuleBaselineData.DeserializeDatabaseVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((DatabaseVulnerabilityAssessmentRuleBaselineData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineData data)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/managedInstances/", false);
            uri.AppendPath(managedInstanceName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineData data)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/managedInstances/", false);
            uri.AppendPath(managedInstanceName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(data, ModelSerializationExtensions.WireOptions);
            request.Content = content;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates or updates a database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="managedInstanceName"> The name of the managed instance. </param>
        /// <param name="databaseName"> The name of the database for which the vulnerability assessment rule baseline is defined. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/>, <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DatabaseVulnerabilityAssessmentRuleBaselineData>> CreateOrUpdateAsync(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(managedInstanceName, nameof(managedInstanceName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, data);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DatabaseVulnerabilityAssessmentRuleBaselineData.DeserializeDatabaseVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates a database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="managedInstanceName"> The name of the managed instance. </param>
        /// <param name="databaseName"> The name of the database for which the vulnerability assessment rule baseline is defined. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="data"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/>, <paramref name="ruleId"/> or <paramref name="data"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DatabaseVulnerabilityAssessmentRuleBaselineData> CreateOrUpdate(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, DatabaseVulnerabilityAssessmentRuleBaselineData data, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(managedInstanceName, nameof(managedInstanceName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(data, nameof(data));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName, data);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseVulnerabilityAssessmentRuleBaselineData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DatabaseVulnerabilityAssessmentRuleBaselineData.DeserializeDatabaseVulnerabilityAssessmentRuleBaselineData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/managedInstances/", false);
            uri.AppendPath(managedInstanceName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/managedInstances/", false);
            uri.AppendPath(managedInstanceName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/vulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToSerialString(), true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Removes the database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="managedInstanceName"> The name of the managed instance. </param>
        /// <param name="databaseName"> The name of the database for which the vulnerability assessment rule baseline is defined. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(managedInstanceName, nameof(managedInstanceName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Removes the database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="managedInstanceName"> The name of the managed instance. </param>
        /// <param name="databaseName"> The name of the database for which the vulnerability assessment rule baseline is defined. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="baselineName"> The name of the vulnerability assessment rule baseline (default implies a baseline on a database level rule and master for server level rule). </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="managedInstanceName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string managedInstanceName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, string ruleId, VulnerabilityAssessmentPolicyBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(managedInstanceName, nameof(managedInstanceName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, managedInstanceName, databaseName, vulnerabilityAssessmentName, ruleId, baselineName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
