// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    internal partial class DatabaseSqlVulnerabilityAssessmentRuleBaselinesRestOperations
    {
        private readonly TelemetryDetails _userAgent;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> Initializes a new instance of DatabaseSqlVulnerabilityAssessmentRuleBaselinesRestOperations. </summary>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="applicationId"> The application id to use for user agent. </param>
        /// <param name="endpoint"> server parameter. </param>
        /// <param name="apiVersion"> Api Version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="pipeline"/> or <paramref name="apiVersion"/> is null. </exception>
        public DatabaseSqlVulnerabilityAssessmentRuleBaselinesRestOperations(HttpPipeline pipeline, string applicationId, Uri endpoint = null, string apiVersion = default)
        {
            _pipeline = pipeline ?? throw new ArgumentNullException(nameof(pipeline));
            _endpoint = endpoint ?? new Uri("https://management.azure.com");
            _apiVersion = apiVersion ?? "2022-11-01-preview";
            _userAgent = new TelemetryDetails(GetType().Assembly, applicationId);
        }

        internal RequestUriBuilder CreateListByBaselineRequestUri(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateListByBaselineRequest(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a list of database's sql vulnerability assessment rule baselines. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult>> ListByBaselineAsync(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));

            using var message = CreateListByBaselineRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult.DeserializeDatabaseSqlVulnerabilityAssessmentRuleBaselineListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of database's sql vulnerability assessment rule baselines. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult> ListByBaseline(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));

            using var message = CreateListByBaselineRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult.DeserializeDatabaseSqlVulnerabilityAssessmentRuleBaselineListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateGetRequestUri(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateGetRequest(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a database's sql vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SqlVulnerabilityAssessmentBaselineRuleData>> GetAsync(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentBaselineRuleData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SqlVulnerabilityAssessmentBaselineRuleData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a database's sql vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SqlVulnerabilityAssessmentBaselineRuleData> Get(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateGetRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentBaselineRuleData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                case 404:
                    return Response.FromValue((SqlVulnerabilityAssessmentBaselineRuleData)null, message.Response);
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateCreateOrUpdateRequestUri(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateCreateOrUpdateRequest(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Put;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            request.Headers.Add("Content-Type", "application/json");
            var content0 = new Utf8JsonRequestContent();
            content0.JsonWriter.WriteObjectValue(content, ModelSerializationExtensions.WireOptions);
            request.Content = content0;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Creates or updates a database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/>, <paramref name="ruleId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<SqlVulnerabilityAssessmentBaselineRuleData>> CreateOrUpdateAsync(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId, content);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentBaselineRuleData value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Creates or updates a database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="content"> The requested rule baseline resource. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/>, <paramref name="ruleId"/> or <paramref name="content"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<SqlVulnerabilityAssessmentBaselineRuleData> CreateOrUpdate(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, SqlVulnerabilityAssessmentBaselineRuleCreateOrUpdateContent content, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));
            Argument.AssertNotNull(content, nameof(content));

            using var message = CreateCreateOrUpdateRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId, content);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        SqlVulnerabilityAssessmentBaselineRuleData value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = SqlVulnerabilityAssessmentBaselineRuleData.DeserializeSqlVulnerabilityAssessmentBaselineRuleData(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateDeleteRequestUri(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            return uri;
        }

        internal HttpMessage CreateDeleteRequest(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Delete;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendPath("/subscriptions/", false);
            uri.AppendPath(subscriptionId, true);
            uri.AppendPath("/resourceGroups/", false);
            uri.AppendPath(resourceGroupName, true);
            uri.AppendPath("/providers/Microsoft.Sql/servers/", false);
            uri.AppendPath(serverName, true);
            uri.AppendPath("/databases/", false);
            uri.AppendPath(databaseName, true);
            uri.AppendPath("/sqlVulnerabilityAssessments/", false);
            uri.AppendPath(vulnerabilityAssessmentName.ToString(), true);
            uri.AppendPath("/baselines/", false);
            uri.AppendPath(baselineName.ToString(), true);
            uri.AppendPath("/rules/", false);
            uri.AppendPath(ruleId, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            request.Uri = uri;
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Removes the database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response> DeleteAsync(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Removes the database's vulnerability assessment rule baseline. </summary>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="ruleId"> The vulnerability assessment rule ID. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/>, <paramref name="databaseName"/> or <paramref name="ruleId"/> is an empty string, and was expected to be non-empty. </exception>
        public Response Delete(string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, string ruleId, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));
            Argument.AssertNotNullOrEmpty(ruleId, nameof(ruleId));

            using var message = CreateDeleteRequest(subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName, ruleId);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                case 204:
                    return message.Response;
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        internal RequestUriBuilder CreateListByBaselineNextPageRequestUri(string nextLink, string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName)
        {
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            return uri;
        }

        internal HttpMessage CreateListByBaselineNextPageRequest(string nextLink, string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName)
        {
            var message = _pipeline.CreateMessage();
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            _userAgent.Apply(message);
            return message;
        }

        /// <summary> Gets a list of database's sql vulnerability assessment rule baselines. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is an empty string, and was expected to be non-empty. </exception>
        public async Task<Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult>> ListByBaselineNextPageAsync(string nextLink, string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));

            using var message = CreateListByBaselineNextPageRequest(nextLink, subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            await _pipeline.SendAsync(message, cancellationToken).ConfigureAwait(false);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult value = default;
                        using var document = await JsonDocument.ParseAsync(message.Response.ContentStream, default, cancellationToken).ConfigureAwait(false);
                        value = DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult.DeserializeDatabaseSqlVulnerabilityAssessmentRuleBaselineListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }

        /// <summary> Gets a list of database's sql vulnerability assessment rule baselines. </summary>
        /// <param name="nextLink"> The URL to the next page of results. </param>
        /// <param name="subscriptionId"> The subscription ID that identifies an Azure subscription. </param>
        /// <param name="resourceGroupName"> The name of the resource group that contains the resource. You can obtain this value from the Azure Resource Manager API or the portal. </param>
        /// <param name="serverName"> The name of the server. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="vulnerabilityAssessmentName"> The name of the vulnerability assessment. </param>
        /// <param name="baselineName"> The <see cref="SqlVulnerabilityAssessmentBaselineName"/> to use. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="nextLink"/>, <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="subscriptionId"/>, <paramref name="resourceGroupName"/>, <paramref name="serverName"/> or <paramref name="databaseName"/> is an empty string, and was expected to be non-empty. </exception>
        public Response<DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult> ListByBaselineNextPage(string nextLink, string subscriptionId, string resourceGroupName, string serverName, string databaseName, VulnerabilityAssessmentName vulnerabilityAssessmentName, SqlVulnerabilityAssessmentBaselineName baselineName, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(nextLink, nameof(nextLink));
            Argument.AssertNotNullOrEmpty(subscriptionId, nameof(subscriptionId));
            Argument.AssertNotNullOrEmpty(resourceGroupName, nameof(resourceGroupName));
            Argument.AssertNotNullOrEmpty(serverName, nameof(serverName));
            Argument.AssertNotNullOrEmpty(databaseName, nameof(databaseName));

            using var message = CreateListByBaselineNextPageRequest(nextLink, subscriptionId, resourceGroupName, serverName, databaseName, vulnerabilityAssessmentName, baselineName);
            _pipeline.Send(message, cancellationToken);
            switch (message.Response.Status)
            {
                case 200:
                    {
                        DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult value = default;
                        using var document = JsonDocument.Parse(message.Response.ContentStream);
                        value = DatabaseSqlVulnerabilityAssessmentRuleBaselineListResult.DeserializeDatabaseSqlVulnerabilityAssessmentRuleBaselineListResult(document.RootElement);
                        return Response.FromValue(value, message.Response);
                    }
                default:
                    throw new RequestFailedException(message.Response);
            }
        }
    }
}
