// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    /// <summary>
    /// A class representing the RecoverableDatabase data model.
    /// A recoverable database resource.
    /// </summary>
    public partial class RecoverableDatabaseData : ResourceData
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RecoverableDatabaseData"/>. </summary>
        public RecoverableDatabaseData()
        {
            Keys = new ChangeTrackingDictionary<string, SqlDatabaseKey>();
        }

        /// <summary> Initializes a new instance of <see cref="RecoverableDatabaseData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="edition"> The edition of the database. </param>
        /// <param name="serviceLevelObjective"> The service level objective name of the database. </param>
        /// <param name="elasticPoolName"> The elastic pool name of the database. </param>
        /// <param name="lastAvailableBackupOn"> The last available backup date. </param>
        /// <param name="keys"> The resource ids of the user assigned identities to use. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RecoverableDatabaseData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, string edition, string serviceLevelObjective, string elasticPoolName, DateTimeOffset? lastAvailableBackupOn, IDictionary<string, SqlDatabaseKey> keys, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(id, name, resourceType, systemData)
        {
            Edition = edition;
            ServiceLevelObjective = serviceLevelObjective;
            ElasticPoolName = elasticPoolName;
            LastAvailableBackupOn = lastAvailableBackupOn;
            Keys = keys;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The edition of the database. </summary>
        [WirePath("properties.edition")]
        public string Edition { get; }
        /// <summary> The service level objective name of the database. </summary>
        [WirePath("properties.serviceLevelObjective")]
        public string ServiceLevelObjective { get; }
        /// <summary> The elastic pool name of the database. </summary>
        [WirePath("properties.elasticPoolName")]
        public string ElasticPoolName { get; }
        /// <summary> The last available backup date. </summary>
        [WirePath("properties.lastAvailableBackupDate")]
        public DateTimeOffset? LastAvailableBackupOn { get; }
        /// <summary> The resource ids of the user assigned identities to use. </summary>
        [WirePath("properties.keys")]
        public IDictionary<string, SqlDatabaseKey> Keys { get; }
    }
}
