// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Sql.Models;

namespace Azure.ResourceManager.Sql
{
    public partial class RecommendedActionData : IUtf8JsonSerializable, IJsonModel<RecommendedActionData>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<RecommendedActionData>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<RecommendedActionData>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected override void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendedActionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendedActionData)} does not support writing '{format}' format.");
            }

            base.JsonModelWriteCore(writer, options);
            if (options.Format != "W" && Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind);
            }
            if (options.Format != "W" && Optional.IsDefined(Location))
            {
                writer.WritePropertyName("location"u8);
                writer.WriteStringValue(Location.Value);
            }
            writer.WritePropertyName("properties"u8);
            writer.WriteStartObject();
            if (options.Format != "W" && Optional.IsDefined(RecommendationReason))
            {
                writer.WritePropertyName("recommendationReason"u8);
                writer.WriteStringValue(RecommendationReason);
            }
            if (options.Format != "W" && Optional.IsDefined(ValidSince))
            {
                writer.WritePropertyName("validSince"u8);
                writer.WriteStringValue(ValidSince.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastRefresh))
            {
                writer.WritePropertyName("lastRefresh"u8);
                writer.WriteStringValue(LastRefresh.Value, "O");
            }
            if (Optional.IsDefined(State))
            {
                writer.WritePropertyName("state"u8);
                writer.WriteObjectValue(State, options);
            }
            if (options.Format != "W" && Optional.IsDefined(IsExecutableAction))
            {
                writer.WritePropertyName("isExecutableAction"u8);
                writer.WriteBooleanValue(IsExecutableAction.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsRevertableAction))
            {
                writer.WritePropertyName("isRevertableAction"u8);
                writer.WriteBooleanValue(IsRevertableAction.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(IsArchivedAction))
            {
                writer.WritePropertyName("isArchivedAction"u8);
                writer.WriteBooleanValue(IsArchivedAction.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ExecuteActionStartOn))
            {
                writer.WritePropertyName("executeActionStartTime"u8);
                writer.WriteStringValue(ExecuteActionStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ExecuteActionDuration))
            {
                writer.WritePropertyName("executeActionDuration"u8);
                writer.WriteStringValue(ExecuteActionDuration.Value, "P");
            }
            if (options.Format != "W" && Optional.IsDefined(RevertActionStartOn))
            {
                writer.WritePropertyName("revertActionStartTime"u8);
                writer.WriteStringValue(RevertActionStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(RevertActionDuration))
            {
                writer.WritePropertyName("revertActionDuration"u8);
                writer.WriteStringValue(RevertActionDuration.Value, "P");
            }
            if (options.Format != "W" && Optional.IsDefined(ExecuteActionInitiatedBy))
            {
                writer.WritePropertyName("executeActionInitiatedBy"u8);
                writer.WriteStringValue(ExecuteActionInitiatedBy.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(ExecuteActionInitiatedOn))
            {
                writer.WritePropertyName("executeActionInitiatedTime"u8);
                writer.WriteStringValue(ExecuteActionInitiatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(RevertActionInitiatedBy))
            {
                writer.WritePropertyName("revertActionInitiatedBy"u8);
                writer.WriteStringValue(RevertActionInitiatedBy.Value.ToSerialString());
            }
            if (options.Format != "W" && Optional.IsDefined(RevertActionInitiatedOn))
            {
                writer.WritePropertyName("revertActionInitiatedTime"u8);
                writer.WriteStringValue(RevertActionInitiatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(Score))
            {
                writer.WritePropertyName("score"u8);
                writer.WriteNumberValue(Score.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ImplementationDetails))
            {
                writer.WritePropertyName("implementationDetails"u8);
                writer.WriteObjectValue(ImplementationDetails, options);
            }
            if (options.Format != "W" && Optional.IsDefined(ErrorDetails))
            {
                writer.WritePropertyName("errorDetails"u8);
                writer.WriteObjectValue(ErrorDetails, options);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(EstimatedImpact))
            {
                writer.WritePropertyName("estimatedImpact"u8);
                writer.WriteStartArray();
                foreach (var item in EstimatedImpact)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(ObservedImpact))
            {
                writer.WritePropertyName("observedImpact"u8);
                writer.WriteStartArray();
                foreach (var item in ObservedImpact)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(TimeSeries))
            {
                writer.WritePropertyName("timeSeries"u8);
                writer.WriteStartArray();
                foreach (var item in TimeSeries)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(LinkedObjects))
            {
                writer.WritePropertyName("linkedObjects"u8);
                writer.WriteStartArray();
                foreach (var item in LinkedObjects)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Details))
            {
                writer.WritePropertyName("details"u8);
                writer.WriteStartObject();
                foreach (var item in Details)
                {
                    writer.WritePropertyName(item.Key);
                    if (item.Value == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                writer.WriteEndObject();
            }
            writer.WriteEndObject();
        }

        RecommendedActionData IJsonModel<RecommendedActionData>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendedActionData>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(RecommendedActionData)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeRecommendedActionData(document.RootElement, options);
        }

        internal static RecommendedActionData DeserializeRecommendedActionData(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string kind = default;
            AzureLocation? location = default;
            ResourceIdentifier id = default;
            string name = default;
            ResourceType type = default;
            SystemData systemData = default;
            string recommendationReason = default;
            DateTimeOffset? validSince = default;
            DateTimeOffset? lastRefresh = default;
            RecommendedActionStateInfo state = default;
            bool? isExecutableAction = default;
            bool? isRevertableAction = default;
            bool? isArchivedAction = default;
            DateTimeOffset? executeActionStartTime = default;
            TimeSpan? executeActionDuration = default;
            DateTimeOffset? revertActionStartTime = default;
            TimeSpan? revertActionDuration = default;
            RecommendedActionInitiatedBy? executeActionInitiatedBy = default;
            DateTimeOffset? executeActionInitiatedTime = default;
            RecommendedActionInitiatedBy? revertActionInitiatedBy = default;
            DateTimeOffset? revertActionInitiatedTime = default;
            int? score = default;
            RecommendedActionImplementationInfo implementationDetails = default;
            RecommendedActionErrorInfo errorDetails = default;
            IReadOnlyList<RecommendedActionImpactRecord> estimatedImpact = default;
            IReadOnlyList<RecommendedActionImpactRecord> observedImpact = default;
            IReadOnlyList<RecommendedActionMetricInfo> timeSeries = default;
            IReadOnlyList<string> linkedObjects = default;
            IReadOnlyDictionary<string, BinaryData> details = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    kind = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("location"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    location = new AzureLocation(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("id"u8))
                {
                    id = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("name"u8))
                {
                    name = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("type"u8))
                {
                    type = new ResourceType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("systemData"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    systemData = JsonSerializer.Deserialize<SystemData>(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("properties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        property.ThrowNonNullablePropertyIsNull();
                        continue;
                    }
                    foreach (var property0 in property.Value.EnumerateObject())
                    {
                        if (property0.NameEquals("recommendationReason"u8))
                        {
                            recommendationReason = property0.Value.GetString();
                            continue;
                        }
                        if (property0.NameEquals("validSince"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            validSince = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("lastRefresh"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            lastRefresh = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("state"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            state = RecommendedActionStateInfo.DeserializeRecommendedActionStateInfo(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("isExecutableAction"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isExecutableAction = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isRevertableAction"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isRevertableAction = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("isArchivedAction"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            isArchivedAction = property0.Value.GetBoolean();
                            continue;
                        }
                        if (property0.NameEquals("executeActionStartTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            executeActionStartTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("executeActionDuration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            executeActionDuration = property0.Value.GetTimeSpan("P");
                            continue;
                        }
                        if (property0.NameEquals("revertActionStartTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            revertActionStartTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("revertActionDuration"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            revertActionDuration = property0.Value.GetTimeSpan("P");
                            continue;
                        }
                        if (property0.NameEquals("executeActionInitiatedBy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            executeActionInitiatedBy = property0.Value.GetString().ToRecommendedActionInitiatedBy();
                            continue;
                        }
                        if (property0.NameEquals("executeActionInitiatedTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            executeActionInitiatedTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("revertActionInitiatedBy"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            revertActionInitiatedBy = property0.Value.GetString().ToRecommendedActionInitiatedBy();
                            continue;
                        }
                        if (property0.NameEquals("revertActionInitiatedTime"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            revertActionInitiatedTime = property0.Value.GetDateTimeOffset("O");
                            continue;
                        }
                        if (property0.NameEquals("score"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            score = property0.Value.GetInt32();
                            continue;
                        }
                        if (property0.NameEquals("implementationDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            implementationDetails = RecommendedActionImplementationInfo.DeserializeRecommendedActionImplementationInfo(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("errorDetails"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            errorDetails = RecommendedActionErrorInfo.DeserializeRecommendedActionErrorInfo(property0.Value, options);
                            continue;
                        }
                        if (property0.NameEquals("estimatedImpact"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<RecommendedActionImpactRecord> array = new List<RecommendedActionImpactRecord>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(RecommendedActionImpactRecord.DeserializeRecommendedActionImpactRecord(item, options));
                            }
                            estimatedImpact = array;
                            continue;
                        }
                        if (property0.NameEquals("observedImpact"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<RecommendedActionImpactRecord> array = new List<RecommendedActionImpactRecord>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(RecommendedActionImpactRecord.DeserializeRecommendedActionImpactRecord(item, options));
                            }
                            observedImpact = array;
                            continue;
                        }
                        if (property0.NameEquals("timeSeries"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<RecommendedActionMetricInfo> array = new List<RecommendedActionMetricInfo>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(RecommendedActionMetricInfo.DeserializeRecommendedActionMetricInfo(item, options));
                            }
                            timeSeries = array;
                            continue;
                        }
                        if (property0.NameEquals("linkedObjects"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            List<string> array = new List<string>();
                            foreach (var item in property0.Value.EnumerateArray())
                            {
                                array.Add(item.GetString());
                            }
                            linkedObjects = array;
                            continue;
                        }
                        if (property0.NameEquals("details"u8))
                        {
                            if (property0.Value.ValueKind == JsonValueKind.Null)
                            {
                                continue;
                            }
                            Dictionary<string, BinaryData> dictionary = new Dictionary<string, BinaryData>();
                            foreach (var property1 in property0.Value.EnumerateObject())
                            {
                                if (property1.Value.ValueKind == JsonValueKind.Null)
                                {
                                    dictionary.Add(property1.Name, null);
                                }
                                else
                                {
                                    dictionary.Add(property1.Name, BinaryData.FromString(property1.Value.GetRawText()));
                                }
                            }
                            details = dictionary;
                            continue;
                        }
                    }
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new RecommendedActionData(
                id,
                name,
                type,
                systemData,
                kind,
                location,
                recommendationReason,
                validSince,
                lastRefresh,
                state,
                isExecutableAction,
                isRevertableAction,
                isArchivedAction,
                executeActionStartTime,
                executeActionDuration,
                revertActionStartTime,
                revertActionDuration,
                executeActionInitiatedBy,
                executeActionInitiatedTime,
                revertActionInitiatedBy,
                revertActionInitiatedTime,
                score,
                implementationDetails,
                errorDetails,
                estimatedImpact ?? new ChangeTrackingList<RecommendedActionImpactRecord>(),
                observedImpact ?? new ChangeTrackingList<RecommendedActionImpactRecord>(),
                timeSeries ?? new ChangeTrackingList<RecommendedActionMetricInfo>(),
                linkedObjects ?? new ChangeTrackingList<string>(),
                details ?? new ChangeTrackingDictionary<string, BinaryData>(),
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Name), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  name: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Name))
                {
                    builder.Append("  name: ");
                    if (Name.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Name}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Name}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Location), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  location: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Location))
                {
                    builder.Append("  location: ");
                    builder.AppendLine($"'{Location.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Kind), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  kind: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Kind))
                {
                    builder.Append("  kind: ");
                    if (Kind.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Kind}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Kind}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Id), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  id: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Id))
                {
                    builder.Append("  id: ");
                    builder.AppendLine($"'{Id.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SystemData), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  systemData: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SystemData))
                {
                    builder.Append("  systemData: ");
                    builder.AppendLine($"'{SystemData.ToString()}'");
                }
            }

            builder.Append("  properties:");
            builder.AppendLine(" {");
            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RecommendationReason), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    recommendationReason: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RecommendationReason))
                {
                    builder.Append("    recommendationReason: ");
                    if (RecommendationReason.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RecommendationReason}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RecommendationReason}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ValidSince), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    validSince: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ValidSince))
                {
                    builder.Append("    validSince: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ValidSince.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastRefresh), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    lastRefresh: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastRefresh))
                {
                    builder.Append("    lastRefresh: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastRefresh.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(State), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    state: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(State))
                {
                    builder.Append("    state: ");
                    BicepSerializationHelpers.AppendChildObject(builder, State, options, 4, false, "    state: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsExecutableAction), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isExecutableAction: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsExecutableAction))
                {
                    builder.Append("    isExecutableAction: ");
                    var boolValue = IsExecutableAction.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsRevertableAction), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isRevertableAction: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsRevertableAction))
                {
                    builder.Append("    isRevertableAction: ");
                    var boolValue = IsRevertableAction.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsArchivedAction), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    isArchivedAction: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsArchivedAction))
                {
                    builder.Append("    isArchivedAction: ");
                    var boolValue = IsArchivedAction.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExecuteActionStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    executeActionStartTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExecuteActionStartOn))
                {
                    builder.Append("    executeActionStartTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ExecuteActionStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExecuteActionDuration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    executeActionDuration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExecuteActionDuration))
                {
                    builder.Append("    executeActionDuration: ");
                    var formattedTimeSpan = TypeFormatters.ToString(ExecuteActionDuration.Value, "P");
                    builder.AppendLine($"'{formattedTimeSpan}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RevertActionStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    revertActionStartTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RevertActionStartOn))
                {
                    builder.Append("    revertActionStartTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(RevertActionStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RevertActionDuration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    revertActionDuration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RevertActionDuration))
                {
                    builder.Append("    revertActionDuration: ");
                    var formattedTimeSpan = TypeFormatters.ToString(RevertActionDuration.Value, "P");
                    builder.AppendLine($"'{formattedTimeSpan}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExecuteActionInitiatedBy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    executeActionInitiatedBy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExecuteActionInitiatedBy))
                {
                    builder.Append("    executeActionInitiatedBy: ");
                    builder.AppendLine($"'{ExecuteActionInitiatedBy.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ExecuteActionInitiatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    executeActionInitiatedTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ExecuteActionInitiatedOn))
                {
                    builder.Append("    executeActionInitiatedTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ExecuteActionInitiatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RevertActionInitiatedBy), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    revertActionInitiatedBy: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RevertActionInitiatedBy))
                {
                    builder.Append("    revertActionInitiatedBy: ");
                    builder.AppendLine($"'{RevertActionInitiatedBy.Value.ToSerialString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RevertActionInitiatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    revertActionInitiatedTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RevertActionInitiatedOn))
                {
                    builder.Append("    revertActionInitiatedTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(RevertActionInitiatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Score), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    score: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Score))
                {
                    builder.Append("    score: ");
                    builder.AppendLine($"{Score.Value}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImplementationDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    implementationDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImplementationDetails))
                {
                    builder.Append("    implementationDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ImplementationDetails, options, 4, false, "    implementationDetails: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ErrorDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    errorDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ErrorDetails))
                {
                    builder.Append("    errorDetails: ");
                    BicepSerializationHelpers.AppendChildObject(builder, ErrorDetails, options, 4, false, "    errorDetails: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EstimatedImpact), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    estimatedImpact: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(EstimatedImpact))
                {
                    if (EstimatedImpact.Any())
                    {
                        builder.Append("    estimatedImpact: ");
                        builder.AppendLine("[");
                        foreach (var item in EstimatedImpact)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    estimatedImpact: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ObservedImpact), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    observedImpact: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ObservedImpact))
                {
                    if (ObservedImpact.Any())
                    {
                        builder.Append("    observedImpact: ");
                        builder.AppendLine("[");
                        foreach (var item in ObservedImpact)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    observedImpact: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TimeSeries), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    timeSeries: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(TimeSeries))
                {
                    if (TimeSeries.Any())
                    {
                        builder.Append("    timeSeries: ");
                        builder.AppendLine("[");
                        foreach (var item in TimeSeries)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 6, true, "    timeSeries: ");
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LinkedObjects), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    linkedObjects: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(LinkedObjects))
                {
                    if (LinkedObjects.Any())
                    {
                        builder.Append("    linkedObjects: ");
                        builder.AppendLine("[");
                        foreach (var item in LinkedObjects)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("      '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"      '{item}'");
                            }
                        }
                        builder.AppendLine("    ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Details), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("    details: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Details))
                {
                    if (Details.Any())
                    {
                        builder.Append("    details: ");
                        builder.AppendLine("{");
                        foreach (var item in Details)
                        {
                            builder.Append($"        '{item.Key}': ");
                            if (item.Value == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            builder.AppendLine($"'{item.Value.ToString()}'");
                        }
                        builder.AppendLine("    }");
                    }
                }
            }

            builder.AppendLine("  }");
            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<RecommendedActionData>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendedActionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(RecommendedActionData)} does not support writing '{options.Format}' format.");
            }
        }

        RecommendedActionData IPersistableModel<RecommendedActionData>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<RecommendedActionData>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeRecommendedActionData(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(RecommendedActionData)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<RecommendedActionData>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
