// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The scan trigger type. </summary>
    public readonly partial struct VulnerabilityAssessmentScanTriggerType : IEquatable<VulnerabilityAssessmentScanTriggerType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentScanTriggerType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VulnerabilityAssessmentScanTriggerType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnDemandValue = "OnDemand";
        private const string RecurringValue = "Recurring";

        /// <summary> OnDemand. </summary>
        public static VulnerabilityAssessmentScanTriggerType OnDemand { get; } = new VulnerabilityAssessmentScanTriggerType(OnDemandValue);
        /// <summary> Recurring. </summary>
        public static VulnerabilityAssessmentScanTriggerType Recurring { get; } = new VulnerabilityAssessmentScanTriggerType(RecurringValue);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentScanTriggerType"/> values are the same. </summary>
        public static bool operator ==(VulnerabilityAssessmentScanTriggerType left, VulnerabilityAssessmentScanTriggerType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentScanTriggerType"/> values are not the same. </summary>
        public static bool operator !=(VulnerabilityAssessmentScanTriggerType left, VulnerabilityAssessmentScanTriggerType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VulnerabilityAssessmentScanTriggerType"/>. </summary>
        public static implicit operator VulnerabilityAssessmentScanTriggerType(string value) => new VulnerabilityAssessmentScanTriggerType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VulnerabilityAssessmentScanTriggerType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VulnerabilityAssessmentScanTriggerType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
