// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The scan status. </summary>
    public readonly partial struct VulnerabilityAssessmentScanState : IEquatable<VulnerabilityAssessmentScanState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentScanState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VulnerabilityAssessmentScanState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PassedValue = "Passed";
        private const string FailedValue = "Failed";
        private const string FailedToRunValue = "FailedToRun";
        private const string InProgressValue = "InProgress";

        /// <summary> Passed. </summary>
        public static VulnerabilityAssessmentScanState Passed { get; } = new VulnerabilityAssessmentScanState(PassedValue);
        /// <summary> Failed. </summary>
        public static VulnerabilityAssessmentScanState Failed { get; } = new VulnerabilityAssessmentScanState(FailedValue);
        /// <summary> FailedToRun. </summary>
        public static VulnerabilityAssessmentScanState FailedToRun { get; } = new VulnerabilityAssessmentScanState(FailedToRunValue);
        /// <summary> InProgress. </summary>
        public static VulnerabilityAssessmentScanState InProgress { get; } = new VulnerabilityAssessmentScanState(InProgressValue);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentScanState"/> values are the same. </summary>
        public static bool operator ==(VulnerabilityAssessmentScanState left, VulnerabilityAssessmentScanState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentScanState"/> values are not the same. </summary>
        public static bool operator !=(VulnerabilityAssessmentScanState left, VulnerabilityAssessmentScanState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VulnerabilityAssessmentScanState"/>. </summary>
        public static implicit operator VulnerabilityAssessmentScanState(string value) => new VulnerabilityAssessmentScanState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VulnerabilityAssessmentScanState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VulnerabilityAssessmentScanState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
