// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> The VulnerabilityAssessmentName. </summary>
    public readonly partial struct VulnerabilityAssessmentName : IEquatable<VulnerabilityAssessmentName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="VulnerabilityAssessmentName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public VulnerabilityAssessmentName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DefaultValue = "default";

        /// <summary> default. </summary>
        public static VulnerabilityAssessmentName Default { get; } = new VulnerabilityAssessmentName(DefaultValue);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentName"/> values are the same. </summary>
        public static bool operator ==(VulnerabilityAssessmentName left, VulnerabilityAssessmentName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="VulnerabilityAssessmentName"/> values are not the same. </summary>
        public static bool operator !=(VulnerabilityAssessmentName left, VulnerabilityAssessmentName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="VulnerabilityAssessmentName"/>. </summary>
        public static implicit operator VulnerabilityAssessmentName(string value) => new VulnerabilityAssessmentName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is VulnerabilityAssessmentName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(VulnerabilityAssessmentName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
