// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Sql.Models
{
    /// <summary> An update request for virtual cluster. </summary>
    public partial class VirtualClusterPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="VirtualClusterPatch"/>. </summary>
        public VirtualClusterPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            ChildResources = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="VirtualClusterPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="subnetId"> Subnet resource ID for the virtual cluster. </param>
        /// <param name="version"> Virtual cluster version. </param>
        /// <param name="childResources"> List of resources in this virtual cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal VirtualClusterPatch(IDictionary<string, string> tags, ResourceIdentifier subnetId, string version, IReadOnlyList<string> childResources, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            SubnetId = subnetId;
            Version = version;
            ChildResources = childResources;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        [WirePath("tags")]
        public IDictionary<string, string> Tags { get; }
        /// <summary> Subnet resource ID for the virtual cluster. </summary>
        [WirePath("properties.subnetId")]
        public ResourceIdentifier SubnetId { get; }
        /// <summary> Virtual cluster version. </summary>
        [WirePath("properties.version")]
        public string Version { get; set; }
        /// <summary> List of resources in this virtual cluster. </summary>
        [WirePath("properties.childResources")]
        public IReadOnlyList<string> ChildResources { get; }
    }
}
